/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.connectormodel.loader.descriptor;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.HTTPMethod;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.ConnectorModelBuilder;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.OperationBuilder;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.TriggerBuilder;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.TriggerParameterBuilder;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.TypeDefinitionBuilder;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.generic.ParameterDataType;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.loader.descriptor.DescriptorSampleDataLoader;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.loader.descriptor.DescriptorTypeLoader;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.loader.descriptor.DescriptorValueProviderLoader;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter.ParameterType;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ConnectorDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.DataTypeDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ParameterBindingDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.TriggerDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.TriggerParameterDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.resolvers.ResolverExpressionDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.sampledata.SampleDataDefinitionDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.valueprovider.ValueProviderDefinitionDescriptor;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;

public class DescriptorTriggerLoader {
    static void loadTriggers(ConnectorDescriptor connectorDescriptor, ConnectorModelBuilder connectorBuilder) {
        if (connectorDescriptor.getTriggers() == null) {
            return;
        }
        List<TriggerDescriptor> nonNativeTriggers = connectorDescriptor.getTriggers().stream().filter(triggerDescriptor -> StringUtils.isBlank((String)triggerDescriptor.getFqn())).collect(Collectors.toList());
        nonNativeTriggers.stream().filter(triggerDescriptor -> triggerDescriptor.getBase() == null).forEach(triggerDescriptor -> DescriptorTriggerLoader.loadTrigger(triggerDescriptor, connectorBuilder.getOrCreateTriggerBuilder(triggerDescriptor.getName()), connectorBuilder));
        List<TriggerDescriptor> orderedTriggers = DescriptorTriggerLoader.orderTriggersDependencies(nonNativeTriggers, connectorBuilder);
        orderedTriggers.stream().filter(triggerDescriptor -> triggerDescriptor.getBase() != null).forEach(triggerDescriptor -> DescriptorTriggerLoader.loadTriggerAdapter(triggerDescriptor, connectorBuilder));
        connectorDescriptor.getTriggers().stream().filter(triggerDescriptor -> StringUtils.isNotBlank((String)triggerDescriptor.getFqn())).forEach(triggerDescriptor -> DescriptorTriggerLoader.loadNativeTrigger(triggerDescriptor, connectorBuilder.getOrCreateTriggerBuilder(triggerDescriptor.getName())));
    }

    private static List<TriggerDescriptor> orderTriggersDependencies(List<TriggerDescriptor> nonNativeTriggers, ConnectorModelBuilder connectorBuilder) {
        ArrayList<TriggerDescriptor> orderedTriggers = new ArrayList<TriggerDescriptor>();
        nonNativeTriggers.stream().filter(triggerDescriptor -> triggerDescriptor.getBase() == null || connectorBuilder.getTriggerBuilders().stream().anyMatch(x -> x.getName().equals(triggerDescriptor.getBase()))).forEach(triggerDescriptor -> orderedTriggers.add((TriggerDescriptor)triggerDescriptor));
        List reducedList = nonNativeTriggers.stream().filter(triggerDescriptor -> orderedTriggers.stream().noneMatch(y -> y.equals(triggerDescriptor))).collect(Collectors.toList());
        while (reducedList.size() > 0) {
            ArrayList auxReduced = new ArrayList(reducedList);
            for (TriggerDescriptor triggerDescriptor2 : auxReduced) {
                TriggerDescriptor parent = orderedTriggers.stream().filter(x -> x.getName().equals(triggerDescriptor2.getBase())).findFirst().orElse(null);
                if (parent == null) continue;
                orderedTriggers.add(triggerDescriptor2);
                reducedList.remove(triggerDescriptor2);
            }
        }
        return orderedTriggers;
    }

    private static void loadTrigger(TriggerDescriptor triggerDescriptor, TriggerBuilder triggerBuilder, ConnectorModelBuilder connectorBuilder) {
        Optional<OperationBuilder> baseOperationBuilder = connectorBuilder.getOperationBuildersByOperationIdOrMethodPath(triggerDescriptor.getBaseEndpoint());
        triggerBuilder.itemsExpression(triggerDescriptor.getItemsExpression()).outputMediaType(triggerDescriptor.getOutputMediaType()).identityExpression(triggerDescriptor.getIdentityExpression()).outputTypeSchema(triggerDescriptor.getOutputTypeSchema() != null ? triggerDescriptor.getOutputTypeSchema().getContent() : null).muleMetadataScope(triggerDescriptor.getMuleMetadataScope()).displayName(triggerDescriptor.getDisplayName()).setDescription(triggerDescriptor.getDescription()).alias(triggerDescriptor.getAlias()).ignored(triggerDescriptor.getIgnored()).refined(triggerDescriptor.getRefined()).eventExpression(triggerDescriptor.getEventExpression()).startValue(triggerDescriptor.getStartValueExpression());
        if (baseOperationBuilder.isPresent()) {
            triggerBuilder.operationId(baseOperationBuilder.get().getDescriptorIdentifier()).path(baseOperationBuilder.get().getPath()).method(baseOperationBuilder.get().getMethod() != null ? HTTPMethod.fromString(baseOperationBuilder.get().getMethod()) : null);
        }
        if (triggerDescriptor.getWatermark() != null) {
            triggerBuilder.watermarkExpression(triggerDescriptor.getWatermark().getValue());
            if (triggerDescriptor.getWatermark().getDataType() != null) {
                triggerBuilder.watermarkType(ParameterDataType.forName(triggerDescriptor.getWatermark().getDataType().getName()));
            }
        }
        DescriptorTriggerLoader.loadParameterBindings(triggerBuilder, triggerDescriptor);
        DescriptorTriggerLoader.loadParameters(triggerBuilder, triggerDescriptor);
        DescriptorSampleDataLoader.loadSampleData((ResolverExpressionDescriptor<SampleDataDefinitionDescriptor>)triggerDescriptor.getSampleDataExpressionDescriptor(), triggerBuilder.getSampleDataExpressionBuilder());
    }

    private static void loadNativeTrigger(TriggerDescriptor triggerDescriptor, TriggerBuilder triggerBuilder) {
        triggerBuilder.fqn(triggerDescriptor.getFqn());
    }

    private static void loadTriggerAdapter(TriggerDescriptor triggerAdapterDescriptor, ConnectorModelBuilder connectorModelBuilder) {
        TriggerBuilder baseTriggerBuilder = DescriptorTriggerLoader.resolveBaseTriggerBuilder(triggerAdapterDescriptor, connectorModelBuilder);
        TriggerBuilder triggerBuilder = connectorModelBuilder.createTriggerAdapterBuilder(triggerAdapterDescriptor.getName(), baseTriggerBuilder);
        if (Optional.ofNullable(triggerAdapterDescriptor.getSidecarTrigger()).orElse(false).booleanValue()) {
            triggerBuilder.sidecar();
        }
        Optional.ofNullable(triggerAdapterDescriptor.getDisplayName()).ifPresent(triggerBuilder::displayName);
        Optional.ofNullable(triggerAdapterDescriptor.getDescription()).ifPresent(triggerBuilder::setDescription);
        Optional.ofNullable(triggerAdapterDescriptor.getEventExpression()).ifPresent(triggerBuilder::eventExpression);
        Optional.ofNullable(triggerAdapterDescriptor.getStartValueExpression()).ifPresent(triggerBuilder::startValue);
        Optional.ofNullable(triggerAdapterDescriptor.getOutputMediaType()).ifPresent(triggerBuilder::outputMediaType);
        Optional.ofNullable(triggerAdapterDescriptor.getMuleMetadataScope()).ifPresent(triggerBuilder::muleMetadataScope);
        if (triggerAdapterDescriptor.getOutputTypeSchema() != null) {
            Optional.ofNullable(triggerAdapterDescriptor.getOutputTypeSchema().getContent()).ifPresent(triggerBuilder::outputTypeSchema);
        }
        DescriptorTriggerLoader.loadParameters(triggerBuilder, triggerAdapterDescriptor);
        DescriptorTriggerLoader.loadParameterBindings(triggerBuilder, triggerAdapterDescriptor);
        DescriptorSampleDataLoader.loadSampleData((ResolverExpressionDescriptor<SampleDataDefinitionDescriptor>)triggerAdapterDescriptor.getSampleDataExpressionDescriptor(), triggerBuilder.getSampleDataExpressionBuilder());
    }

    private static TriggerBuilder resolveBaseTriggerBuilder(TriggerDescriptor triggerAdapterDescriptor, ConnectorModelBuilder connectorModelBuilder) {
        String baseTriggerName = triggerAdapterDescriptor.getBase();
        TriggerBuilder triggerBuildersByTriggerName = connectorModelBuilder.getTriggerBuildersByName(baseTriggerName).orElseThrow(() -> new IllegalArgumentException(String.format("Base trigger not found '%s'. This is a bug.", baseTriggerName)));
        return triggerBuildersByTriggerName;
    }

    private static void loadParameterBindings(TriggerBuilder triggerBuilder, TriggerDescriptor triggerDescriptor) {
        if (triggerDescriptor.getParameterBindings() == null) {
            return;
        }
        triggerBuilder.requestBodyExpression(triggerDescriptor.getParameterBindings().getWeaveExpression());
        DescriptorTriggerLoader.loadParameterBindings(triggerDescriptor.getParameterBindings().getUriParameters(), ParameterType.URI, triggerBuilder);
        DescriptorTriggerLoader.loadParameterBindings(triggerDescriptor.getParameterBindings().getQueryParameters(), ParameterType.QUERY, triggerBuilder);
        DescriptorTriggerLoader.loadParameterBindings(triggerDescriptor.getParameterBindings().getHeaders(), ParameterType.HEADER, triggerBuilder);
    }

    private static void loadParameterBindings(List<ParameterBindingDescriptor> parameterBindings, ParameterType parameterType, TriggerBuilder triggerBuilder) {
        for (ParameterBindingDescriptor bindingDescriptor : parameterBindings) {
            triggerBuilder.getOrCreateParameterBindingBuilder(bindingDescriptor.getName(), parameterType).value(bindingDescriptor.getValue());
        }
    }

    private static void loadParameters(TriggerBuilder triggerBuilder, TriggerDescriptor triggerDescriptor) {
        if (triggerDescriptor.getParameters() == null) {
            return;
        }
        for (TriggerParameterDescriptor parameterDescriptor : triggerDescriptor.getParameters()) {
            TriggerParameterBuilder triggerParameterBuilder = triggerBuilder.getOrCreateParameterBuilder(parameterDescriptor.getName());
            triggerParameterBuilder.displayName(parameterDescriptor.getDisplayName());
            triggerParameterBuilder.description(parameterDescriptor.getDescription());
            triggerParameterBuilder.muleMetadataKeyId(parameterDescriptor.getMuleMetadataKeyId());
            triggerParameterBuilder.muleTypeResolver(parameterDescriptor.getMuleTypeResolver());
            triggerParameterBuilder.muleContent(parameterDescriptor.getMuleContent());
            triggerParameterBuilder.muleAlias(parameterDescriptor.getMuleAlias());
            triggerParameterBuilder.required(parameterDescriptor.isRequired());
            DataTypeDescriptor dataType = parameterDescriptor.getDataType();
            if (dataType != null) {
                ParameterDataType parameterDataType = ParameterDataType.forName(dataType.getName());
                triggerParameterBuilder.dataType(parameterDataType);
            } else {
                TypeDefinitionBuilder typeDefinitionBuilder = triggerParameterBuilder.getTypeDefinitionBuilder();
                if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)parameterDescriptor.getInputType().getContent())) {
                    typeDefinitionBuilder.object().typeSchema(() -> parameterDescriptor.getInputType().getContent());
                }
                typeDefinitionBuilder.mediaType(DescriptorTypeLoader.loadMediaType(parameterDescriptor.getContentType()));
            }
            DescriptorValueProviderLoader.loadValueProvider((ResolverExpressionDescriptor<ValueProviderDefinitionDescriptor>)parameterDescriptor.getValueProvider(), triggerParameterBuilder.getValueProviderExpressionBuilder());
        }
    }
}

