/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.connectormodel.type;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.type.PrimitiveTypeDefinition;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.type.schema.TypeSchema;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.util.HashCodeUtil;
import java.util.List;
import javax.ws.rs.core.MediaType;

public abstract class TypeDefinition {
    protected final MediaType mediaType;
    protected final String example;
    protected final List<String> enumValues;
    protected final TypeSchema typeSchema;
    protected final String displayName;
    protected final String description;
    protected final Boolean required;

    TypeDefinition(MediaType mediaType, String example, List<String> enumValues, TypeSchema typeSchema, String displayName, String description) {
        this(mediaType, example, enumValues, typeSchema, displayName, description, false);
    }

    TypeDefinition(MediaType mediaType, String example, List<String> enumValues, TypeSchema typeSchema, String displayName, String description, Boolean required) {
        this.mediaType = mediaType;
        this.example = example;
        this.enumValues = enumValues;
        this.typeSchema = typeSchema;
        this.displayName = displayName;
        this.description = description;
        this.required = required;
    }

    public MediaType getMediaType() {
        return this.mediaType;
    }

    public String getExample() {
        return this.example;
    }

    public List<String> getEnumValues() {
        return this.enumValues;
    }

    public TypeSchema getTypeSchema() {
        return this.typeSchema;
    }

    public boolean isEnum() {
        return this.enumValues != null && !this.enumValues.isEmpty();
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public Boolean isRequired() {
        return this.required;
    }

    public static TypeDefinition simplePrimitiveType(PrimitiveTypeDefinition.PrimitiveType type) {
        return new PrimitiveTypeDefinition(MediaType.TEXT_PLAIN_TYPE, null, null, null, type, null, null, false);
    }

    public static TypeDefinition simpleStringType() {
        return TypeDefinition.simplePrimitiveType(PrimitiveTypeDefinition.PrimitiveType.STRING);
    }

    public int hashCode() {
        String mediaTypeString = this.mediaType != null ? this.mediaType.toString() : null;
        return HashCodeUtil.generateHashCode(mediaTypeString, this.example, this.enumValues, this.typeSchema);
    }
}

