/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.templating.sdk;

import static org.apache.commons.lang3.StringUtils.EMPTY;

import com.mulesoft.connectivity.rest.commons.api.operation.paging.MarkerPagingProvider;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorModel;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorOperation;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.pagination.InPaginationParameter;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.pagination.OutPaginationParameter;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.pagination.PaginationParameter;
import com.mulesoft.connectivity.rest.sdk.templating.api.RestSdkRunConfiguration;
import com.mulesoft.connectivity.rest.sdk.templating.exception.TemplatingException;

import java.nio.file.Path;

import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.ParameterSpec;

public class SdkMarkerPaginationOperation extends AbstractSdkPaginationOperation {

  public static final String NEXT_TOKEN_EXPRESSION = "nextTokenExpression";
  public static final String NEXT_TOKEN_PARAM_NAME = "nextTokenParamName";

  public SdkMarkerPaginationOperation(Path outputDir, ConnectorModel connectorModel, SdkConnector sdkConnector,
                                      ConnectorOperation operation, RestSdkRunConfiguration runConfiguration)
      throws TemplatingException {
    super(outputDir, connectorModel, sdkConnector, operation, runConfiguration);
  }

  @Override
  public String getInitialPagingParameterSummary() {
    return EMPTY;
  }

  @Override
  public ParameterSpec generateInitialPagingParameter() {
    return null;
  }

  @Override
  public CodeBlock getPagingMethodOperation() {
    CodeBlock.Builder paginationBody = CodeBlock.builder();
    paginationBody.addStatement(
                                "return new $T($S, $S, requestFactory, expressionLanguage, streamingHelper, $S, resolveDefaultResponseMediaType(config), overrides.getResponseTimeoutAsMillis())",
                                getPagingProvider(),
                                getTokenParamName(),
                                getNextTokenExpression(),
                                getPayloadExpression());
    return paginationBody.build();
  }

  @Override
  public Class getPagingProvider() {
    return MarkerPagingProvider.class;
  }

  private String getNextTokenExpression() {
    PaginationParameter parameter = getPagination().getParameter(NEXT_TOKEN_EXPRESSION);

    return (parameter == null) ? null : ((InPaginationParameter) parameter).getValueExtraction().getContent();
  }

  @Override
  public String getTokenParamName() {
    PaginationParameter parameter = getPagination().getParameter(NEXT_TOKEN_PARAM_NAME);

    return (parameter == null) ? null : ((OutPaginationParameter) parameter).getValue();
  }

  @Override
  public String getInitialParamName() {
    return NEXT_TOKEN_EXPRESSION;
  }
}
