/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.templating.sdk;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorModel;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorOperation;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.type.MultipartTypeDefinition;
import com.mulesoft.connectivity.rest.sdk.templating.api.RestSdkRunConfiguration;
import com.mulesoft.connectivity.rest.sdk.templating.exception.TemplatingException;

import java.nio.file.Path;

public class SdkOperationFactory {

  public static AbstractSdkOperation create(Path outputDir, ConnectorModel connectorModel, SdkConnector sdkConnector,
                                            ConnectorOperation operation, RestSdkRunConfiguration runConfiguration)
      throws TemplatingException {
    if (operation.hasPagination()) {
      String pagingType = connectorModel.getPagination(operation.getPagination()).getType();
      if ("offset".equalsIgnoreCase(pagingType)) {
        return new SdkOffsetPaginationOperation(outputDir, connectorModel, sdkConnector, operation, runConfiguration);
      } else if ("marker".equalsIgnoreCase(pagingType)) {
        return new SdkMarkerPaginationOperation(outputDir, connectorModel, sdkConnector, operation, runConfiguration);
      } else if ("pageNumber".equalsIgnoreCase(pagingType)) {
        return new SdkPageNumberPaginationOperation(outputDir, connectorModel, sdkConnector, operation, runConfiguration);
      }
    }

    if (operation.getInputMetadata() instanceof MultipartTypeDefinition) {
      return new SdkMultipartOperation(outputDir, connectorModel, sdkConnector, operation, runConfiguration);
    }

    return new SdkOperation(outputDir, connectorModel, sdkConnector, operation, runConfiguration);
  }

}
