/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.templating.sdk;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorModel;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter.ConnectorModelParameter;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter.Parameter;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.type.ArrayTypeDefinition;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.type.TypeDefinition;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.util.JavaUtils;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.util.XmlUtils;
import com.mulesoft.connectivity.rest.sdk.templating.JavaTemplateEntity;
import com.mulesoft.connectivity.rest.sdk.templating.api.RestSdkRunConfiguration;
import com.mulesoft.connectivity.rest.sdk.templating.exception.TemplatingException;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.SdkConnector;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.SdkOperation;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.SdkTypeDefinitionUtils;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.SdkValueProvider;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.nio.file.Path;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.Modifier;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.extension.api.annotation.connectivity.oauth.OAuthParameter;
import org.mule.runtime.extension.api.annotation.param.NullSafe;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.extension.api.annotation.values.OfValues;

public class SdkParameter
extends JavaTemplateEntity {
    private final Parameter parameter;
    private final TypeDefinition typeDefinition;
    private final String enumClassName;
    private final String enumClassPackage;
    private final SdkValueProvider valueProvider;

    public SdkParameter(Path outputDir, ConnectorModel connectorModel, SdkConnector sdkConnector, String parentJavaName, Parameter parameter, JavaTemplateEntity parentElement, RestSdkRunConfiguration runConfiguration) throws TemplatingException {
        super(outputDir, connectorModel, runConfiguration);
        this.parameter = parameter;
        this.typeDefinition = parameter.getTypeDefinition();
        this.enumClassName = this.typeDefinition.isEnum() ? SdkParameter.buildEnumName(sdkConnector.getEnumValuesName(), parentJavaName, this) : null;
        this.enumClassPackage = connectorModel.getBasePackage() + ".api.metadata";
        this.valueProvider = this.buildSdkValueProvider(parentElement);
    }

    private SdkValueProvider buildSdkValueProvider(JavaTemplateEntity parentElement) throws TemplatingException {
        ConnectorModelParameter connectorModelParameter;
        if (this.parameter instanceof ConnectorModelParameter && (connectorModelParameter = (ConnectorModelParameter)this.parameter).getValueResolverReference() != null) {
            if (parentElement instanceof SdkOperation) {
                return new SdkValueProvider(this.outputDir, this.connectorModel, connectorModelParameter, (SdkOperation)parentElement, this.runConfiguration);
            }
            throw new TemplatingException("Value Provider generation not supported for " + connectorModelParameter.getValueResolverReference().getClass());
        }
        return null;
    }

    public String getExternalName() {
        return this.parameter.getExternalName();
    }

    public String getJavaName() {
        return JavaUtils.getParameterJavaName((String)this.parameter.getInternalName(), (boolean)this.isArrayType());
    }

    public String getDisplayName() {
        return this.parameter.getDisplayName();
    }

    public String getDescription() {
        return this.parameter.getDescription();
    }

    public boolean isArrayType() {
        return this.typeDefinition instanceof ArrayTypeDefinition;
    }

    public TypeName getTypeName() {
        return this.parameter.getTypeDefinition().isEnum() ? ClassName.get((String)this.enumClassPackage, (String)this.enumClassName, (String[])new String[0]) : SdkParameter.getParameterTypeName(this.typeDefinition, false);
    }

    private static TypeName getParameterTypeName(TypeDefinition typeDefinition, boolean isInnerType) {
        if (typeDefinition instanceof ArrayTypeDefinition) {
            TypeDefinition innerType = ((ArrayTypeDefinition)typeDefinition).getInnerType();
            return ParameterizedTypeName.get((ClassName)ClassName.get(List.class), (TypeName[])new TypeName[]{SdkParameter.getParameterTypeName(innerType, true)});
        }
        Type parameterPrimitiveJavaType = SdkParameter.getParameterPrimitiveJavaType(typeDefinition);
        if (isInnerType && parameterPrimitiveJavaType.equals(Boolean.TYPE)) {
            return TypeName.get(Boolean.class);
        }
        return TypeName.get((Type)parameterPrimitiveJavaType);
    }

    private static Type getParameterPrimitiveJavaType(TypeDefinition typeDefinition) {
        if (typeDefinition instanceof ArrayTypeDefinition) {
            throw new IllegalArgumentException("Type is not primitive. Should handle arrays in templating.");
        }
        Type javaType = SdkTypeDefinitionUtils.getJavaType(typeDefinition);
        if (javaType.equals(InputStream.class)) {
            return String.class;
        }
        if (javaType.equals(Date.class)) {
            return String.class;
        }
        return javaType;
    }

    @Override
    public void applyTemplates() throws TemplatingException {
        if (this.typeDefinition.isEnum()) {
            this.generateEnumClass();
        }
        if (this.valueProvider != null) {
            this.valueProvider.applyTemplates();
        }
    }

    private void generateEnumClass() throws TemplatingException {
        MethodSpec enumConstructor = MethodSpec.constructorBuilder().addParameter(String.class, "value", new Modifier[0]).addCode(CodeBlock.builder().addStatement("this.value = value", new Object[0]).build()).build();
        MethodSpec valueGetterMethod = MethodSpec.methodBuilder((String)"getValue").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(String.class).addCode(CodeBlock.builder().addStatement("return value", new Object[0]).build()).build();
        TypeSpec.Builder enumClassBuilder = TypeSpec.enumBuilder((String)this.enumClassName).addModifiers(new Modifier[]{Modifier.PUBLIC}).addField(String.class, "value", new Modifier[]{Modifier.PRIVATE}).addMethod(enumConstructor).addMethod(valueGetterMethod);
        for (String enumConstant : this.parameter.getTypeDefinition().getEnumValues()) {
            enumClassBuilder.addEnumConstant(JavaUtils.getJavaConstantNameFromXml((String)XmlUtils.getXmlName((String)enumConstant)), TypeSpec.anonymousClassBuilder((String)"$S", (Object[])new Object[]{enumConstant}).build());
        }
        JavaFile.Builder javaFileBuilder = JavaFile.builder((String)this.enumClassPackage, (TypeSpec)enumClassBuilder.build()).skipJavaLangImports(true);
        this.writeJavaFile(javaFileBuilder.build());
    }

    private static String buildEnumName(Map<List<String>, String> enumValuesName, String parentJavaName, SdkParameter sdkParameter) {
        List enumValuesKey = enumValuesName.keySet().stream().filter(x -> x.equals(sdkParameter.typeDefinition.getEnumValues())).findFirst().orElse(null);
        if (enumValuesKey != null) {
            return enumValuesName.get(enumValuesKey);
        }
        String parameterNameBasedEnumName = StringUtils.capitalize((String)sdkParameter.getJavaName()) + "Enum";
        if (!enumValuesName.containsValue(parameterNameBasedEnumName)) {
            enumValuesName.put(sdkParameter.typeDefinition.getEnumValues(), parameterNameBasedEnumName);
            return parameterNameBasedEnumName;
        }
        String operationNameBasedEnumName = parentJavaName + parameterNameBasedEnumName;
        enumValuesName.put(sdkParameter.typeDefinition.getEnumValues(), operationNameBasedEnumName);
        return operationNameBasedEnumName;
    }

    public ParameterSpec.Builder generateParameterParameter() {
        AnnotationSpec nullSafeAnnotation;
        ParameterSpec.Builder paramSpecBuilder = ParameterSpec.builder((TypeName)this.getTypeName(), (String)this.getJavaName(), (Modifier[])new Modifier[0]);
        AnnotationSpec optionalAnnotation = this.getOptionalAnnotation();
        if (optionalAnnotation != null) {
            paramSpecBuilder.addAnnotation(optionalAnnotation);
        }
        if ((nullSafeAnnotation = this.getNullSafeAnnotation()) != null) {
            paramSpecBuilder.addAnnotation(nullSafeAnnotation);
        }
        paramSpecBuilder.addAnnotation(this.getDisplayNameAnnotation());
        AnnotationSpec summaryAnnotation = this.getSummaryAnnotation();
        if (summaryAnnotation != null) {
            paramSpecBuilder.addAnnotation(summaryAnnotation);
        }
        if (this.valueProvider != null) {
            paramSpecBuilder.addAnnotation(this.getValueProviderAnnotation());
        }
        return paramSpecBuilder;
    }

    private AnnotationSpec getValueProviderAnnotation() {
        return AnnotationSpec.builder(OfValues.class).addMember("value", "$T.class", new Object[]{ClassName.get((String)this.valueProvider.getPackage(), (String)this.valueProvider.getJavaClassName(), (String[])new String[0])}).build();
    }

    public FieldSpec.Builder generateParameterField() {
        AnnotationSpec parameterAnnotation = AnnotationSpec.builder(org.mule.runtime.extension.api.annotation.param.Parameter.class).build();
        return this.generateParameterField(parameterAnnotation);
    }

    public FieldSpec.Builder generateOAuthParameterField() {
        AnnotationSpec parameterAnnotation = AnnotationSpec.builder(OAuthParameter.class).addMember("requestAlias", "$S", new Object[]{this.parameter.getExternalName()}).build();
        return this.generateParameterField(parameterAnnotation);
    }

    private FieldSpec.Builder generateParameterField(AnnotationSpec parameterAnnotation) {
        AnnotationSpec summaryAnnotation;
        FieldSpec.Builder fieldSpecBuilder = FieldSpec.builder((TypeName)this.getTypeName(), (String)this.getJavaName(), (Modifier[])new Modifier[0]).addAnnotation(parameterAnnotation).addAnnotation(this.getDisplayNameAnnotation());
        AnnotationSpec optionalAnnotation = this.getOptionalAnnotation();
        if (optionalAnnotation != null) {
            fieldSpecBuilder.addAnnotation(optionalAnnotation);
        }
        if ((summaryAnnotation = this.getSummaryAnnotation()) != null) {
            fieldSpecBuilder.addAnnotation(summaryAnnotation);
        }
        return fieldSpecBuilder;
    }

    private AnnotationSpec getNullSafeAnnotation() {
        if (!this.parameter.isRequired() && this.isArrayType()) {
            return AnnotationSpec.builder(NullSafe.class).build();
        }
        return null;
    }

    private AnnotationSpec getOptionalAnnotation() {
        if (!this.parameter.isRequired() || StringUtils.isNotBlank((CharSequence)this.parameter.getDefaultValue())) {
            AnnotationSpec.Builder optionalBuilder = AnnotationSpec.builder(Optional.class);
            if (StringUtils.isNotBlank((CharSequence)this.parameter.getDefaultValue())) {
                if (this.parameter.getTypeDefinition().isEnum()) {
                    optionalBuilder.addMember("defaultValue", "$S", new Object[]{JavaUtils.getJavaConstantNameFromXml((String)XmlUtils.getXmlName((String)this.parameter.getDefaultValue()))});
                } else {
                    optionalBuilder.addMember("defaultValue", "$S", new Object[]{this.parameter.getDefaultValue()});
                }
            }
            return optionalBuilder.build();
        }
        return null;
    }

    private AnnotationSpec getDisplayNameAnnotation() {
        return AnnotationSpec.builder(DisplayName.class).addMember("value", "$S", new Object[]{this.parameter.getDisplayName()}).build();
    }

    private AnnotationSpec getSummaryAnnotation() {
        if (StringUtils.isNotBlank((CharSequence)this.parameter.getDescription())) {
            return AnnotationSpec.builder(Summary.class).addMember("value", "$S", new Object[]{JavaUtils.abbreviateText((String)this.parameter.getDescription())}).build();
        }
        return null;
    }

    public String getStringValueGetter() {
        return SdkParameter.getStringValueGetter(this.typeDefinition, this.getJavaName(), this.parameter.isRequired());
    }

    public String getStringValueGetter(String varName) {
        return SdkParameter.getStringValueGetter(this.typeDefinition, varName, this.parameter.isRequired());
    }

    public String getInnerTypeStringValueGetter(String varName) {
        return SdkParameter.getStringValueGetter(((ArrayTypeDefinition)this.typeDefinition).getInnerType(), varName, true);
    }

    private static String getStringValueGetter(TypeDefinition typeDefinition, String varName, boolean required) {
        StringBuilder stringBuilder = new StringBuilder();
        Type javaType = SdkTypeDefinitionUtils.getJavaType(typeDefinition);
        if (SdkParameter.requiresNullCheck(required, typeDefinition.isEnum(), javaType)) {
            stringBuilder.append(varName).append(" != null ? ");
        }
        if (typeDefinition.isEnum()) {
            stringBuilder.append(varName).append(".getValue()");
        } else if (javaType.equals(String.class)) {
            stringBuilder.append(varName);
        } else {
            stringBuilder.append("String.valueOf(").append(varName).append(")");
        }
        if (SdkParameter.requiresNullCheck(required, typeDefinition.isEnum(), javaType)) {
            stringBuilder.append(" : null");
        }
        return stringBuilder.toString();
    }

    private static boolean requiresNullCheck(boolean required, boolean isEnum, Type javaType) {
        return !required && (isEnum || !javaType.equals(Boolean.TYPE) && !javaType.equals(String.class));
    }
}

