/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.templating.sdk;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorModel;
import com.mulesoft.connectivity.rest.sdk.templating.VelocityTemplateEntity;
import com.mulesoft.connectivity.rest.sdk.templating.exception.TemplatingException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;

public class SdkPom
extends VelocityTemplateEntity {
    private static final String POM_VM = "templates/sdk/pom.vm";
    private static final String PROPERTIES_FROM_POM_PROPERTIES = "properties-from-pom.properties";
    private static final String PROJECT_VERSION = "project_version";
    private final ConnectorModel model;
    private final String restSdkCommonsVersion;

    public SdkPom(Path outputDir, ConnectorModel model) throws TemplatingException {
        super(outputDir);
        this.model = model;
        this.restSdkCommonsVersion = this.getProjectVersion();
    }

    public String getName() {
        return this.model.getConnectorName();
    }

    public String getDescription() {
        return this.model.getApiDescription();
    }

    public String getMvnGroupId() {
        return this.model.getMvnGroupId();
    }

    public String getMvnArtifactId() {
        return StringUtils.isNotBlank((CharSequence)this.model.getMvnArtifactId()) ? this.model.getMvnArtifactId() : this.model.getConnectorXmlName();
    }

    public String getMvnVersion() {
        return this.model.getMvnVersion();
    }

    public String getRestSdkCommonsVersion() {
        return this.restSdkCommonsVersion;
    }

    @Override
    public void applyTemplates() throws TemplatingException {
        this.applyTemplate(POM_VM, this.outputDir.resolve("pom.xml"));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getProjectVersion() throws TemplatingException {
        try (InputStream input = this.getClass().getClassLoader().getResourceAsStream(PROPERTIES_FROM_POM_PROPERTIES);){
            if (input == null) {
                throw new TemplatingException("property file 'properties-from-pom.properties' not found in the classpath, this is a bug");
            }
            Properties prop = new Properties();
            prop.load(input);
            String project_version = prop.getProperty(PROJECT_VERSION);
            if (StringUtils.isBlank((CharSequence)project_version)) {
                throw new TemplatingException("the property 'PROJECT_VERSION' (under 'PROPERTIES_FROM_POM_PROPERTIES') is either null or empty, this is a bug");
            }
            String string = project_version;
            return string;
        }
        catch (IOException e) {
            throw new TemplatingException("property file 'properties-from-pom.properties' from the classpath could not be loaded, this is a bug", e);
        }
    }
}

