/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.templating.sdk;

import com.mulesoft.connectivity.rest.commons.api.datasense.resolver.output.BooleanOutputMetadataResolver;
import com.mulesoft.connectivity.rest.commons.api.datasense.resolver.output.DateOnlyOutputMetadataResolver;
import com.mulesoft.connectivity.rest.commons.api.datasense.resolver.output.DateTimeOutputMetadataResolver;
import com.mulesoft.connectivity.rest.commons.api.datasense.resolver.output.FileOutputMetadataResolver;
import com.mulesoft.connectivity.rest.commons.api.datasense.resolver.output.FromJsonOutputMetadataResolver;
import com.mulesoft.connectivity.rest.commons.api.datasense.resolver.output.IntegerOutputMetadataResolver;
import com.mulesoft.connectivity.rest.commons.api.datasense.resolver.output.JsonOutputMetadataResolver;
import com.mulesoft.connectivity.rest.commons.api.datasense.resolver.output.NumberOutputMetadataResolver;
import com.mulesoft.connectivity.rest.commons.api.datasense.resolver.output.StringOutputMetadataResolver;
import com.mulesoft.connectivity.rest.commons.api.datasense.resolver.output.TimeOnlyOutputMetadataResolver;
import com.mulesoft.connectivity.rest.commons.api.datasense.resolver.output.XmlOutputMetadataResolver;
import com.mulesoft.connectivity.rest.commons.api.datasense.resolver.output.dynamic.FromJsonOutputDynamicMetadataResolver;
import com.mulesoft.connectivity.rest.commons.api.datasense.resolver.output.dynamic.JsonOutputDynamicMetadataResolver;
import com.mulesoft.connectivity.rest.commons.api.datasense.resolver.output.dynamic.XmlOutputDynamicMetadataResolver;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorModel;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorOperation;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.type.PrimitiveTypeDefinition;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.type.TypeDefinition;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.type.schema.CustomTypeSchema;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.type.schema.JsonTypeSchema;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.type.schema.TypeSchema;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.type.schema.XmlTypeSchema;
import com.mulesoft.connectivity.rest.sdk.templating.api.RestSdkRunConfiguration;
import com.mulesoft.connectivity.rest.sdk.templating.exception.TemplatingException;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.SdkAbstractStaticMetadataResolver;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.SdkConnector;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.util.FileGenerationUtils;
import java.nio.file.Path;
import javax.ws.rs.core.MediaType;

public class SdkOutputMetadataResolver
extends SdkAbstractStaticMetadataResolver {
    private String qName;

    public SdkOutputMetadataResolver(Path outputDir, ConnectorModel connectorModel, SdkConnector sdkConnector, ConnectorOperation operation, TypeDefinition typeDefinition, String classNameOverride, RestSdkRunConfiguration runConfiguration) throws TemplatingException {
        super(outputDir, connectorModel, sdkConnector, operation, typeDefinition, FileGenerationUtils.SchemaNameType.OUTPUT, "", classNameOverride, runConfiguration);
    }

    @Override
    protected Class<?> buildSuperclass(TypeDefinition typeDefinition) throws TemplatingException {
        TypeSchema typeSchema = typeDefinition.getTypeSchema();
        if (typeDefinition instanceof PrimitiveTypeDefinition) {
            return this.getPrimitiveMetadataResolverClass((PrimitiveTypeDefinition)typeDefinition);
        }
        if (typeSchema instanceof XmlTypeSchema || typeDefinition.getMediaType().isCompatible(MediaType.APPLICATION_XML_TYPE)) {
            this.qName = ((XmlTypeSchema)typeDefinition.getTypeSchema()).getElementName();
            return this.runConfiguration.useDynamicTypeResolvers() ? XmlOutputDynamicMetadataResolver.class : XmlOutputMetadataResolver.class;
        }
        if (typeSchema instanceof JsonTypeSchema || typeDefinition.getMediaType().isCompatible(MediaType.APPLICATION_JSON_TYPE)) {
            return this.runConfiguration.useDynamicTypeResolvers() ? JsonOutputDynamicMetadataResolver.class : JsonOutputMetadataResolver.class;
        }
        if (typeSchema instanceof CustomTypeSchema) {
            return this.runConfiguration.useDynamicTypeResolvers() ? FromJsonOutputDynamicMetadataResolver.class : FromJsonOutputMetadataResolver.class;
        }
        return StringOutputMetadataResolver.class;
    }

    protected Class<?> getPrimitiveMetadataResolverClass(PrimitiveTypeDefinition primitiveTypeDefinition) throws TemplatingException {
        PrimitiveTypeDefinition.PrimitiveType primitiveType = primitiveTypeDefinition.getPrimitiveType();
        if (primitiveType.equals((Object)PrimitiveTypeDefinition.PrimitiveType.NUMBER)) {
            return NumberOutputMetadataResolver.class;
        }
        if (primitiveType.equals((Object)PrimitiveTypeDefinition.PrimitiveType.INTEGER)) {
            return IntegerOutputMetadataResolver.class;
        }
        if (primitiveType.equals((Object)PrimitiveTypeDefinition.PrimitiveType.STRING)) {
            return StringOutputMetadataResolver.class;
        }
        if (primitiveType.equals((Object)PrimitiveTypeDefinition.PrimitiveType.BOOLEAN)) {
            return BooleanOutputMetadataResolver.class;
        }
        if (primitiveType.equals((Object)PrimitiveTypeDefinition.PrimitiveType.DATE_TIME) || primitiveType.equals((Object)PrimitiveTypeDefinition.PrimitiveType.DATE_TIME_ONLY)) {
            return DateTimeOutputMetadataResolver.class;
        }
        if (primitiveType.equals((Object)PrimitiveTypeDefinition.PrimitiveType.TIME_ONLY)) {
            return TimeOnlyOutputMetadataResolver.class;
        }
        if (primitiveType.equals((Object)PrimitiveTypeDefinition.PrimitiveType.DATE_ONLY) || primitiveType.equals((Object)PrimitiveTypeDefinition.PrimitiveType.DATE)) {
            return DateOnlyOutputMetadataResolver.class;
        }
        if (primitiveType.equals((Object)PrimitiveTypeDefinition.PrimitiveType.FILE)) {
            return FileOutputMetadataResolver.class;
        }
        throw new TemplatingException("Primitive type not supported: " + primitiveType.name());
    }

    @Override
    protected String getClassNameSuffix() {
        return "OutputMetadataResolver";
    }

    @Override
    protected boolean requiresQNameMethod() {
        return this.superclass.equals(XmlOutputMetadataResolver.class) || this.superclass.equals(XmlOutputDynamicMetadataResolver.class);
    }

    @Override
    protected boolean requiresFormatMethod() {
        return this.superclass.equals(FromJsonOutputMetadataResolver.class) || this.superclass.equals(FileOutputMetadataResolver.class) || this.superclass.equals(FromJsonOutputDynamicMetadataResolver.class);
    }

    @Override
    protected String getQName() {
        return this.qName;
    }

    @Override
    protected boolean requiresToWriteSchema() {
        return this.superclass.equals(FromJsonOutputMetadataResolver.class) || this.superclass.equals(JsonOutputMetadataResolver.class) || this.superclass.equals(XmlOutputMetadataResolver.class) || this.superclass.equals(FromJsonOutputDynamicMetadataResolver.class) || this.superclass.equals(JsonOutputDynamicMetadataResolver.class) || this.superclass.equals(XmlOutputDynamicMetadataResolver.class);
    }
}

