/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.templating.sdk;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorModel;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.pagination.Pagination;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter.Parameter;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.type.PrimitiveTypeDefinition;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.type.TypeDefinition;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.PaginationTypeDescriptor;
import com.mulesoft.connectivity.rest.sdk.templating.JavaTemplateEntity;
import com.mulesoft.connectivity.rest.sdk.templating.api.RestSdkRunConfiguration;
import com.mulesoft.connectivity.rest.sdk.templating.exception.TemplatingException;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.SdkConnector;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.SdkParameter;
import java.nio.file.Path;

public class SdkPaginationParameter
extends SdkParameter {
    private final Pagination pagination;

    public SdkPaginationParameter(Path outputDir, ConnectorModel connectorModel, SdkConnector sdkConnector, String parentJavaName, Parameter parameter, JavaTemplateEntity parentElement, RestSdkRunConfiguration runConfiguration, Pagination pagination) throws TemplatingException {
        super(outputDir, connectorModel, sdkConnector, parentJavaName, parameter, parentElement, runConfiguration);
        this.pagination = pagination;
    }

    @Override
    protected TypeDefinition getTypeDefinition() {
        TypeDefinition paginationParameterType = TypeDefinition.simplePrimitiveType((PrimitiveTypeDefinition.PrimitiveType)PrimitiveTypeDefinition.PrimitiveType.INTEGER);
        if (this.pagination.getType().equals((Object)PaginationTypeDescriptor.MARKER)) {
            paginationParameterType = TypeDefinition.simplePrimitiveType((PrimitiveTypeDefinition.PrimitiveType)PrimitiveTypeDefinition.PrimitiveType.STRING);
        }
        return paginationParameterType;
    }

    @Override
    protected String getDefaultValue() {
        if (this.pagination.getType().equals((Object)PaginationTypeDescriptor.PAGE_NUMBER)) {
            return this.pagination.getInitialPageNumber();
        }
        if (this.pagination.getType().equals((Object)PaginationTypeDescriptor.OFFSET)) {
            return this.pagination.getInitialOffset();
        }
        return super.getDefaultValue();
    }
}

