/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.templating.sdk;

import com.mulesoft.connectivity.rest.commons.api.datasense.valueprovider.RestValueProvider;
import com.mulesoft.connectivity.rest.commons.internal.model.builder.common.OperationEvaluationContextBuilder;
import com.mulesoft.connectivity.rest.commons.internal.model.builder.valueprovider.ValueProviderResolverExpressionBuilder;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorModel;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.dataexpression.httprequest.HttpRequestBinding;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.generic.Argument;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter.Parameter;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter.ParameterType;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.resolver.ResolverExpression;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.resolver.ResolverReference;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.util.JavaUtils;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.valueprovider.ValueProviderDefinition;
import com.mulesoft.connectivity.rest.sdk.templating.JavaTemplateEntity;
import com.mulesoft.connectivity.rest.sdk.templating.api.RestSdkRunConfiguration;
import com.mulesoft.connectivity.rest.sdk.templating.exception.TemplatingException;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.SdkOperation;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.SdkParameter;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.nio.file.Path;
import java.util.List;
import javax.lang.model.element.Modifier;

public abstract class AbstractSdkValueProvider
extends JavaTemplateEntity {
    protected static final String ITEMS_EXPRESSION_FIELD = "ITEMS_EXPRESSION";
    protected static final String ITEM_VALUE_EXPRESSION_FIELD = "ITEM_VALUE_EXPRESSION";
    protected static final String ITEM_NAME_EXPRESSION_FIELD = "ITEM_NAME_EXPRESSION";
    protected static final String PATH_TEMPLATE_FIELD = "PATH";
    protected final SdkOperation sdkOperation;
    protected final Parameter parameter;
    protected final ValueProviderDefinition definition;

    public AbstractSdkValueProvider(Path outputDir, ConnectorModel connectorModel, Parameter parameter, SdkOperation operation, RestSdkRunConfiguration runConfiguration) {
        super(outputDir, connectorModel, runConfiguration);
        this.parameter = parameter;
        this.sdkOperation = operation;
        ResolverExpression valueProviderExpression = parameter.getValueProvider();
        this.definition = this.getValueProviderDefinition((ResolverExpression<ValueProviderDefinition>)valueProviderExpression);
    }

    private ValueProviderDefinition getValueProviderDefinition(ResolverExpression<ValueProviderDefinition> valueProviderExpression) {
        if (valueProviderExpression instanceof ValueProviderDefinition) {
            return (ValueProviderDefinition)valueProviderExpression;
        }
        if (valueProviderExpression instanceof ResolverReference) {
            ResolverReference valueProviderReference = (ResolverReference)valueProviderExpression;
            return (ValueProviderDefinition)valueProviderReference.getDeclaration().getResolverDefinition();
        }
        throw new IllegalArgumentException("Invalid valueProviderExpression. This is a bug.");
    }

    public String getPackage() {
        return this.connectorModel.getBasePackage() + ".internal.metadata.values";
    }

    public String getJavaClassName() {
        return this.sdkOperation.getJavaClassName() + JavaUtils.getJavaUpperCamelNameFromXml((String)this.parameter.getInternalName()) + "ValueProvider";
    }

    @Override
    public void applyTemplates() throws TemplatingException {
        if (this.definition != null) {
            this.generateValueProviderClass();
        }
    }

    private void generateValueProviderClass() throws TemplatingException {
        TypeSpec.Builder valueProviderClassBuilder = this.getValueProviderClassBuilder();
        this.buildValueProviderClass(valueProviderClassBuilder);
        JavaFile.Builder javaFileBuilder = this.getJavaFileBuilderForClass(valueProviderClassBuilder.build(), this.getPackage());
        this.writeJavaFile(javaFileBuilder.build());
    }

    private TypeSpec.Builder getValueProviderClassBuilder() {
        TypeSpec.Builder valueProviderClassBuilder = TypeSpec.classBuilder((String)this.getJavaClassName()).addModifiers(new Modifier[]{Modifier.PUBLIC}).superclass(this.getSuperClass());
        this.generateBuildMethod(valueProviderClassBuilder);
        if (this.needsConfigureEvaluationContextMethod()) {
            valueProviderClassBuilder.addMethod(this.generateConfigureEvaluationContextMethod());
        }
        if (this.needsClassConstants()) {
            this.addClassConstants(valueProviderClassBuilder);
        }
        this.addParameterIfNeeded(valueProviderClassBuilder);
        return valueProviderClassBuilder;
    }

    protected boolean needsClassConstants() {
        return true;
    }

    protected boolean needsConfigureEvaluationContextMethod() {
        return true;
    }

    protected TypeName getSuperClass() {
        return TypeName.get(RestValueProvider.class);
    }

    protected void buildValueProviderClass(TypeSpec.Builder valueProviderClassBuilder) {
    }

    protected abstract CodeBlock generateBuildMethodBody();

    protected abstract boolean isBoundParameter(ParameterType var1, SdkParameter var2);

    protected String getBindingMethod(ParameterType parameterType) {
        switch (parameterType) {
            case URI: {
                return "uriParameter";
            }
            case QUERY: {
                return "queryParameter";
            }
            case HEADER: {
                return "header";
            }
        }
        throw new IllegalArgumentException();
    }

    private void generateBuildMethod(TypeSpec.Builder valueProviderClassBuilder) {
        CodeBlock methodBody = this.generateBuildMethodBody();
        if (methodBody != null) {
            MethodSpec.Builder buildMethodBuilder = MethodSpec.methodBuilder((String)"build").addModifiers(new Modifier[]{Modifier.PROTECTED}).addParameter(TypeName.get(ValueProviderResolverExpressionBuilder.class), "builder", new Modifier[0]).addAnnotation(Override.class);
            buildMethodBuilder.addStatement(methodBody);
            valueProviderClassBuilder.addMethod(buildMethodBuilder.build());
        }
    }

    protected CodeBlock.Builder getValueProviderExpressionBuilder() {
        CodeBlock.Builder codeBlockBuilder = CodeBlock.builder();
        codeBlockBuilder.add("builder.definition(definitionBuilder -> definitionBuilder.httpRequest(httpRequestBuilder -> httpRequestBuilder.path($1L).method($2S)", new Object[]{PATH_TEMPLATE_FIELD, this.definition.getRequest().getMethod()});
        HttpRequestBinding bindings = this.definition.getRequest().getHttpRequestBinding();
        if (bindings != null) {
            codeBlockBuilder.add(".bindings(bindingBuilder -> bindingBuilder", new Object[0]);
            bindings.getHeader().forEach(binding -> codeBlockBuilder.add(this.getBindingCode((Argument)binding, ParameterType.HEADER)));
            bindings.getQueryParameter().forEach(binding -> codeBlockBuilder.add(this.getBindingCode((Argument)binding, ParameterType.QUERY)));
            bindings.getUriParameter().forEach(binding -> codeBlockBuilder.add(this.getBindingCode((Argument)binding, ParameterType.URI)));
            codeBlockBuilder.add(")", new Object[0]);
        }
        codeBlockBuilder.add(")", new Object[0]);
        codeBlockBuilder.add(".itemExtractionExpression($1L).itemValueExpression($2L).itemNameExpression($3L))", new Object[]{ITEMS_EXPRESSION_FIELD, ITEM_VALUE_EXPRESSION_FIELD, ITEM_NAME_EXPRESSION_FIELD});
        return codeBlockBuilder;
    }

    private CodeBlock getBindingCode(Argument binding, ParameterType parameterType) {
        CodeBlock.Builder bindingCodeBuilder = CodeBlock.builder();
        bindingCodeBuilder.add(".$1L($2S, argumentBuilder -> argumentBuilder.value(expressionBuilder -> expressionBuilder.expression($3S)))", new Object[]{this.getBindingMethod(parameterType), binding.getName(), binding.getValue().getValue()});
        return bindingCodeBuilder.build();
    }

    private void addClassConstants(TypeSpec.Builder valueProviderClassBuilder) {
        valueProviderClassBuilder.addField(this.getConstantStringField(ITEMS_EXPRESSION_FIELD, this.definition.getItemExtractionExpression())).addField(this.getConstantStringField(ITEM_VALUE_EXPRESSION_FIELD, this.definition.getItemValueExpression())).addField(this.getConstantStringField(ITEM_NAME_EXPRESSION_FIELD, this.definition.getItemDisplayNameExpression())).addField(this.getConstantStringField(PATH_TEMPLATE_FIELD, this.definition.getRequest().getPath()));
    }

    private void addParameterIfNeeded(TypeSpec.Builder valueProviderClassBuilder) {
        this.addParameterIfNeeded(valueProviderClassBuilder, ParameterType.URI, this.sdkOperation.getAllPathParameters());
        this.addParameterIfNeeded(valueProviderClassBuilder, ParameterType.QUERY, this.sdkOperation.getAllQueryParameters());
        this.addParameterIfNeeded(valueProviderClassBuilder, ParameterType.HEADER, this.sdkOperation.getAllHeaders());
    }

    private void addParameterIfNeeded(TypeSpec.Builder valueProviderClassBuilder, ParameterType parameterType, List<SdkParameter> sdkParameters) {
        for (SdkParameter sdkParameter : sdkParameters) {
            if (!this.isBoundParameter(parameterType, sdkParameter)) continue;
            valueProviderClassBuilder.addField(this.getParameterFieldSpec(sdkParameter));
        }
    }

    private FieldSpec getParameterFieldSpec(SdkParameter sdkParameter) {
        FieldSpec.Builder fieldBuilder = FieldSpec.builder((TypeName)sdkParameter.getTypeName(), (String)sdkParameter.getJavaName(), (Modifier[])new Modifier[]{Modifier.PRIVATE}).addAnnotation(org.mule.runtime.extension.api.annotation.param.Parameter.class);
        return fieldBuilder.build();
    }

    private MethodSpec generateConfigureEvaluationContextMethod() {
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)"configureEvaluationContext").addModifiers(new Modifier[]{Modifier.PROTECTED}).addParameter(TypeName.get(OperationEvaluationContextBuilder.class), "builder", new Modifier[0]).addAnnotation(Override.class);
        this.addOperationParameterBinding(methodBuilder, this.sdkOperation.getAllPathParameters(), ParameterType.URI);
        this.addOperationParameterBinding(methodBuilder, this.sdkOperation.getAllQueryParameters(), ParameterType.QUERY);
        this.addOperationParameterBinding(methodBuilder, this.sdkOperation.getAllHeaders(), ParameterType.HEADER);
        return methodBuilder.build();
    }

    private void addOperationParameterBinding(MethodSpec.Builder methodBuilder, List<SdkParameter> parameters, ParameterType parameterType) {
        for (SdkParameter sdkParameter : parameters) {
            if (!this.isBoundParameter(parameterType, sdkParameter)) continue;
            methodBuilder.addStatement("builder.$1L($2S, $3L)", new Object[]{this.getBindingMethod(parameterType), sdkParameter.getExternalName(), sdkParameter.getJavaName()});
        }
    }
}

