/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.templating.sdk;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.util.JavaUtils;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.util.XmlUtils;
import com.mulesoft.connectivity.rest.sdk.templating.api.RestSdkRunConfiguration;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.SdkContent;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.SdkInputMetadataResolver;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.mule.metadata.api.model.ArrayType;
import org.mule.metadata.json.api.JsonTypeLoader;
import org.mule.runtime.extension.api.util.NameUtils;

public class SdkContentNameGenerator {
    private static final String CONTENT_SUFFIX = "Content";
    private static final String CONTENT_DEFAULT_NAME = "content";

    public static String getContentName(RestSdkRunConfiguration runConfiguration, SdkInputMetadataResolver metadataResolver, SdkContent.SdkContentKind contentType, String partName) {
        if (runConfiguration.disambiguateContentParameters()) {
            return SdkContentNameGenerator.generateTypeSpecificContentName(metadataResolver, contentType, partName);
        }
        return SdkContentNameGenerator.generateSimpleContentName(contentType, partName);
    }

    private static String generateSimpleContentName(SdkContent.SdkContentKind contentType, String partName) {
        return contentType.equals((Object)SdkContent.SdkContentKind.INPUT_METADATA) ? CONTENT_DEFAULT_NAME : JavaUtils.getJavaLowerCamelNameFromXml((String)XmlUtils.getXmlName((String)partName)) + CONTENT_SUFFIX;
    }

    private static String generateTypeSpecificContentName(SdkInputMetadataResolver metadataResolver, SdkContent.SdkContentKind contentType, String partName) {
        String schemaName = metadataResolver.getSchemaName();
        if (StringUtils.isNotBlank((CharSequence)schemaName)) {
            JsonTypeLoader jsonTypeLoader;
            Optional metadataType;
            String typeName = null;
            if (contentType.equals((Object)SdkContent.SdkContentKind.INPUT_METADATA)) {
                int index = metadataResolver.getSchemaName().lastIndexOf(".");
                if (index > 0) {
                    schemaName = schemaName.substring(0, index);
                }
                if ((typeName = JavaUtils.getJavaLowerCamelNameFromXml((String)XmlUtils.getXmlName((String)schemaName))).endsWith("InputSchema") && typeName.length() > 11) {
                    typeName = typeName.substring(0, typeName.length() - 11);
                } else if (typeName.endsWith("OutputSchema") && typeName.length() > 12) {
                    typeName = typeName.substring(0, typeName.length() - 12);
                } else if (typeName.endsWith("PartSchema")) {
                    typeName = typeName.substring(0, typeName.length() - 6);
                }
                typeName = typeName + CONTENT_SUFFIX;
            } else if (contentType.equals((Object)SdkContent.SdkContentKind.PART)) {
                typeName = partName + CONTENT_SUFFIX;
            }
            if (schemaName.endsWith(".json") && (metadataType = (jsonTypeLoader = new JsonTypeLoader(metadataResolver.getTypeDefinition().getTypeSchema().getRawSchema())).load(null)).isPresent() && metadataType.get() instanceof ArrayType) {
                return NameUtils.pluralize((String)typeName);
            }
            return typeName;
        }
        return SdkContentNameGenerator.generateSimpleContentName(contentType, partName);
    }
}

