/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.templating.sdk;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorModel;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.generic.Argument;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter.Parameter;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter.ParameterType;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.resolver.ResolverDeclaration;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.resolver.ResolverReference;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.valueprovider.ValueProviderDefinition;
import com.mulesoft.connectivity.rest.sdk.templating.api.RestSdkRunConfiguration;
import com.mulesoft.connectivity.rest.sdk.templating.exception.TemplatingException;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.AbstractSdkValueProvider;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.SdkConnector;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.SdkOperation;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.SdkParameter;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.SdkValueProviderReferenceParent;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.TypeName;
import java.nio.file.Path;

public class SdkValueProviderReference
extends AbstractSdkValueProvider {
    public static final String RESOLVER_NAME_FIELD = "RESOLVER_NAME";
    private final ResolverReference<ValueProviderDefinition> reference;
    private final ResolverDeclaration<ValueProviderDefinition> declaration;
    private final SdkConnector sdkConnector;
    private TypeName superclass;

    public SdkValueProviderReference(Path outputDir, ConnectorModel connectorModel, SdkConnector sdkConnector, Parameter parameter, SdkOperation operation, RestSdkRunConfiguration runConfiguration) {
        super(outputDir, connectorModel, parameter, operation, runConfiguration);
        this.sdkConnector = sdkConnector;
        this.reference = (ResolverReference)parameter.getValueProvider();
        this.declaration = this.reference.getDeclaration();
    }

    @Override
    public void applyTemplates() throws TemplatingException {
        if (!this.sdkConnector.getParentValueProviders().containsKey(this.declaration.getName())) {
            SdkValueProviderReferenceParent parent = new SdkValueProviderReferenceParent(this.outputDir, this.connectorModel, this.parameter, this.sdkOperation, this.runConfiguration);
            parent.applyTemplates();
            this.superclass = parent.getTypeName();
            this.sdkConnector.getParentValueProviders().put(this.declaration.getName(), this.superclass);
        }
        super.applyTemplates();
    }

    @Override
    protected TypeName getSuperClass() {
        return this.superclass;
    }

    @Override
    protected CodeBlock generateBuildMethodBody() {
        CodeBlock.Builder builder = CodeBlock.builder();
        builder.add("builder.reference(referenceBuilder -> referenceBuilder.declaration($1L)", new Object[]{RESOLVER_NAME_FIELD});
        for (Argument arg : this.reference.getArguments()) {
            builder.add(".argument($1S, argumentBuilder -> argumentBuilder.value(valueBuilder -> valueBuilder.expression($2S)))", new Object[]{arg.getName(), arg.getValue().getValue()});
        }
        builder.add(")", new Object[0]);
        return builder.build();
    }

    @Override
    protected boolean isBoundParameter(ParameterType parameterType, SdkParameter sdkParameter) {
        String searchParam = this.getBindingMethod(parameterType) + "." + sdkParameter.getExternalName();
        return this.reference.getArguments().stream().anyMatch(x -> x.getValue().getValue().contains(searchParam));
    }

    @Override
    protected boolean needsClassConstants() {
        return false;
    }
}

