/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.templating;

import com.mulesoft.connectivity.rest.sdk.templating.exception.TemplatingException;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Path;

import org.apache.commons.lang.StringUtils;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.runtime.RuntimeConstants;
import org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader;
import org.apache.velocity.tools.ToolManager;


public abstract class VelocityTemplateEntity extends TemplateEntity {

  private static final ToolManager velocityToolManager;

  static {
    velocityToolManager = new ToolManager();
    velocityToolManager.configure("velocity-tools.xml");
  }

  protected final Path outputDir;
  private final VelocityContext velocityContext;

  protected VelocityTemplateEntity(Path outputDir) {
    this.outputDir = outputDir;
    this.velocityContext = newVelocityContext();
  }

  protected void applyTemplate(String templateVm, Path outputPath) throws TemplatingException {
    outputPath.getParent().toFile().mkdirs();

    VelocityEngine ve = new VelocityEngine();
    ve.setProperty(RuntimeConstants.RESOURCE_LOADER, "classpath");
    ve.setProperty("classpath.resource.loader.class", ClasspathResourceLoader.class.getName());
    ve.init();

    try (BufferedWriter writer = new BufferedWriter(new FileWriter(outputPath.toFile()))) {
      Template template = ve.getTemplate(templateVm, "UTF-8");
      template.merge(velocityContext, writer);
    } catch (IOException e) {
      throw new TemplatingException("Error when applying template", e);
    }
  }

  private VelocityContext newVelocityContext() {
    VelocityContext context = new VelocityContext(velocityToolManager.createContext());

    context.put("StringUtils", StringUtils.class);

    context.internalPut("model", this);

    return context;
  }
}
