/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.templating.sdk;

import com.mulesoft.connectivity.rest.commons.api.operation.paging.PageNumberPagingProvider;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorModel;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorOperation;
import com.mulesoft.connectivity.rest.sdk.templating.api.RestSdkRunConfiguration;
import com.mulesoft.connectivity.rest.sdk.templating.exception.TemplatingException;

import java.nio.file.Path;

public class SdkPageNumberPaginationOperation extends AbstractSdkPaginationOperation {

  public SdkPageNumberPaginationOperation(Path outputDir, ConnectorModel connectorModel, SdkConnector sdkConnector,
                                          ConnectorOperation operation, RestSdkRunConfiguration runConfiguration)
      throws TemplatingException {
    super(outputDir, connectorModel, sdkConnector, operation, runConfiguration);
  }

  @Override
  public Class<?> getPagingProviderClass() {
    return PageNumberPagingProvider.class;
  }
}
