/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.templating.sdk;

import static com.mulesoft.connectivity.rest.sdk.internal.connectormodel.type.PrimitiveTypeDefinition.PrimitiveType.INTEGER;
import static com.mulesoft.connectivity.rest.sdk.internal.connectormodel.type.PrimitiveTypeDefinition.PrimitiveType.STRING;
import static com.mulesoft.connectivity.rest.sdk.internal.connectormodel.type.TypeDefinition.simplePrimitiveType;
import static com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.PaginationTypeDescriptor.MARKER;
import static com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.PaginationTypeDescriptor.OFFSET;
import static com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.PaginationTypeDescriptor.PAGE_NUMBER;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorModel;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.pagination.Pagination;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter.Parameter;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.type.TypeDefinition;
import com.mulesoft.connectivity.rest.sdk.templating.JavaTemplateEntity;
import com.mulesoft.connectivity.rest.sdk.templating.api.RestSdkRunConfiguration;
import com.mulesoft.connectivity.rest.sdk.templating.exception.TemplatingException;

import java.nio.file.Path;

public class SdkPaginationParameter extends SdkParameter {

  private final Pagination pagination;

  public SdkPaginationParameter(Path outputDir, ConnectorModel connectorModel, SdkConnector sdkConnector, String parentJavaName,
                                Parameter parameter, JavaTemplateEntity parentElement, RestSdkRunConfiguration runConfiguration,
                                Pagination pagination)
      throws TemplatingException {
    super(outputDir, connectorModel, sdkConnector, parentJavaName, parameter, parentElement, runConfiguration);
    this.pagination = pagination;
  }

  @Override
  protected TypeDefinition getTypeDefinition() {
    TypeDefinition paginationParameterType = simplePrimitiveType(INTEGER);

    if (pagination.getType().equals(MARKER)) {
      paginationParameterType = simplePrimitiveType(STRING);
    }

    return paginationParameterType;
  }

  @Override
  protected String getDefaultValue() {
    if (pagination.getType().equals(PAGE_NUMBER)) {
      return pagination.getInitialPageNumber();
    }

    if (pagination.getType().equals(OFFSET)) {
      return pagination.getInitialOffset();
    }

    return super.getDefaultValue();
  }
}
