/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.templating.sdk;

import com.mulesoft.connectivity.rest.commons.api.datasense.resolver.output.PagingJsonMetadataResolver;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorModel;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorOperation;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.type.TypeDefinition;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.type.schema.CustomTypeSchema;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.type.schema.JsonTypeSchema;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.type.schema.TypeSchema;
import com.mulesoft.connectivity.rest.sdk.templating.api.RestSdkRunConfiguration;
import com.mulesoft.connectivity.rest.sdk.templating.exception.TemplatingException;

import java.nio.file.Path;

import org.apache.commons.lang3.StringUtils;

public class SdkPagingMetadataResolver extends SdkOutputMetadataResolver {

  public SdkPagingMetadataResolver(Path outputDir,
                                   ConnectorModel connectorModel,
                                   SdkConnector sdkConnector,
                                   ConnectorOperation operation,
                                   TypeDefinition typeDefinition,
                                   RestSdkRunConfiguration runConfiguration)
      throws TemplatingException {
    super(outputDir, connectorModel, sdkConnector, operation, typeDefinition, StringUtils.EMPTY, runConfiguration);
  }

  @Override
  protected Class<?> buildSuperclass(TypeDefinition typeDefinition) throws TemplatingException {
    TypeSchema typeSchema = typeDefinition.getTypeSchema();

    if (typeSchema instanceof JsonTypeSchema || typeSchema instanceof CustomTypeSchema) {
      return PagingJsonMetadataResolver.class;
    }

    throw new TemplatingException("TypeSchema not supported as PagingMetadataResolver (Only Json Schemas are supported)");
  }

  @Override
  protected boolean requiresCategoryNameMethod() {
    return false;
  }

  @Override
  protected String getClassNameSuffix() {
    return "PagingMetadataResolver";
  }

  @Override
  protected boolean requiresToWriteSchema() {
    return true;
  }
}
