/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.templating.sdk;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorModel;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter.Parameter;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter.ParameterType;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.dataexpression.httprequest.HttpRequestBinding;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.generic.Argument;
import com.mulesoft.connectivity.rest.sdk.templating.api.RestSdkRunConfiguration;

import java.nio.file.Path;
import java.util.List;

import com.squareup.javapoet.CodeBlock;

public class SdkValueProviderInline extends AbstractSdkValueProvider {

  public SdkValueProviderInline(Path outputDir,
                                ConnectorModel connectorModel,
                                Parameter parameter,
                                SdkOperation operation,
                                RestSdkRunConfiguration runConfiguration) {
    super(outputDir, connectorModel, parameter, operation, runConfiguration);
  }

  @Override
  protected CodeBlock generateBuildMethodBody() {
    return getValueProviderExpressionBuilder().add(";").build();
  }

  @Override
  protected boolean isBoundParameter(ParameterType parameterType, SdkParameter sdkParameter) {

    HttpRequestBinding httpBinding = definition.getRequest().getHttpRequestBinding();

    if (httpBinding == null) {
      return false;
    }

    List<Argument> parameterBindings;

    switch (parameterType) {
      case URI:
        parameterBindings = httpBinding.getUriParameter();
        break;
      case QUERY:
        parameterBindings = httpBinding.getQueryParameter();
        break;
      case HEADER:
        parameterBindings = httpBinding.getHeader();
        break;
      default:
        throw new IllegalArgumentException("Parameter type not supported. This is a bug.");
    }

    return parameterBindings.stream().anyMatch(x -> x.getValue().getValue()
        .contains(getBindingMethod(parameterType) + "." + sdkParameter.getExternalName()));
  }

}
