/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.templating.sdk;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorModel;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter.Parameter;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter.ParameterType;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.generic.Argument;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.resolver.ResolverDeclaration;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.resolver.ResolverReference;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.valueprovider.ValueProviderDefinition;
import com.mulesoft.connectivity.rest.sdk.templating.api.RestSdkRunConfiguration;
import com.mulesoft.connectivity.rest.sdk.templating.exception.TemplatingException;

import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.TypeName;

import java.nio.file.Path;

public class SdkValueProviderReference extends AbstractSdkValueProvider {

  public static final String RESOLVER_NAME_FIELD = "RESOLVER_NAME";

  private final ResolverReference<ValueProviderDefinition> reference;
  private final ResolverDeclaration<ValueProviderDefinition> declaration;
  private final SdkConnector sdkConnector;
  private TypeName superclass;

  public SdkValueProviderReference(Path outputDir,
                                   ConnectorModel connectorModel,
                                   SdkConnector sdkConnector,
                                   Parameter parameter,
                                   SdkOperation operation,
                                   RestSdkRunConfiguration runConfiguration) {

    super(outputDir, connectorModel, parameter, operation, runConfiguration);

    this.sdkConnector = sdkConnector;
    this.reference = (ResolverReference<ValueProviderDefinition>) parameter.getValueProvider();
    this.declaration = reference.getDeclaration();
  }

  @Override
  public void applyTemplates() throws TemplatingException {
    if (!sdkConnector.getParentValueProviders().containsKey(declaration.getName())) {
      SdkValueProviderReferenceParent parent = new SdkValueProviderReferenceParent(outputDir,
                                                                                   connectorModel,
                                                                                   parameter,
                                                                                   sdkOperation,
                                                                                   runConfiguration);
      parent.applyTemplates();
      this.superclass = parent.getTypeName();
      sdkConnector.getParentValueProviders().put(declaration.getName(), superclass);
    }

    super.applyTemplates();
  }

  @Override
  protected TypeName getSuperClass() {
    return superclass;
  }

  @Override
  protected CodeBlock generateBuildMethodBody() {
    CodeBlock.Builder builder = CodeBlock.builder();

    builder.add("builder.reference(referenceBuilder -> referenceBuilder.declaration($1L)", RESOLVER_NAME_FIELD);

    for (Argument arg : reference.getArguments()) {
      builder.add(".argument($1S, argumentBuilder -> argumentBuilder.value(valueBuilder -> valueBuilder.expression($2S)))",
                  arg.getName(),
                  arg.getValue().getValue());
    }
    builder.add(")");

    return builder.build();
  }

  @Override
  protected boolean isBoundParameter(ParameterType parameterType, SdkParameter sdkParameter) {

    final String searchParam = getBindingMethod(parameterType) + "." + sdkParameter.getExternalName();

    return reference.getArguments().stream()
        .anyMatch(x -> x.getValue().getValue().contains(searchParam));
  }

  @Override
  protected boolean needsClassConstants() {
    return false;
  }
}
