/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.templating.sdk;

import static com.mulesoft.connectivity.rest.sdk.internal.connectormodel.util.JavaUtils.getJavaUpperCamelNameFromXml;
import static com.mulesoft.connectivity.rest.sdk.internal.webapi.util.XmlUtils.getXmlName;
import static javax.lang.model.element.Modifier.ABSTRACT;
import static javax.lang.model.element.Modifier.FINAL;
import static javax.lang.model.element.Modifier.PRIVATE;
import static javax.lang.model.element.Modifier.PROTECTED;
import static javax.lang.model.element.Modifier.STATIC;

import com.mulesoft.connectivity.rest.commons.internal.model.builder.valueprovider.ValueProviderResolverDeclarationBuilder;
import com.mulesoft.connectivity.rest.commons.internal.model.common.DataType;
import com.mulesoft.connectivity.rest.commons.internal.model.common.EvaluationContext;
import com.mulesoft.connectivity.rest.commons.internal.model.common.SimpleEvaluationContext;
import com.mulesoft.connectivity.rest.commons.internal.model.valueprovider.ValueProviderResolverDefinition;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorModel;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter.Parameter;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter.ParameterType;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.resolver.ResolverDeclaration;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.resolver.ResolverParameter;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.resolver.ResolverReference;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.valueprovider.ValueProviderDefinition;
import com.mulesoft.connectivity.rest.sdk.templating.api.RestSdkRunConfiguration;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;

import java.nio.file.Path;
import java.util.Optional;

public class SdkValueProviderReferenceParent extends AbstractSdkValueProvider {

  public static final String GLOBAL_EVALUATION_CONTEXT_FIELD = "globalEvaluationContext";
  public static final String GET_VALUE_PROVIDER_RESOLVER_DECLARATION_METHOD = "getValueProviderResolverDeclaration";
  public static final String GET_GLOBAL_EVALUATION_CONTEXT_METHOD = "getGlobalEvaluationContext";
  public static final String RESOLVER_NAME_FIELD = "RESOLVER_NAME";

  private final ResolverDeclaration<ValueProviderDefinition> declaration;

  public SdkValueProviderReferenceParent(Path outputDir,
                                         ConnectorModel connectorModel,
                                         Parameter parameter,
                                         SdkOperation operation,
                                         RestSdkRunConfiguration runConfiguration) {

    super(outputDir, connectorModel, parameter, operation, runConfiguration);

    this.declaration = ((ResolverReference<ValueProviderDefinition>) parameter.getValueProvider()).getDeclaration();
  }

  @Override
  protected void buildValueProviderClass(TypeSpec.Builder valueProviderClassBuilder) {
    valueProviderClassBuilder
        .addField(generateGlobalContextField())
        .addField(getResolverNameField())
        .addMethod(generateGetGlobalEvaluationContext())
        .addMethod(generateGetValueProviderResolverDeclaration())
        .addModifiers(ABSTRACT);
  }

  private FieldSpec getResolverNameField() {
    return FieldSpec
        .builder(String.class, RESOLVER_NAME_FIELD, PROTECTED, STATIC, FINAL)
        .initializer("$S", declaration.getName())
        .build();
  }

  private FieldSpec generateGlobalContextField() {
    return FieldSpec
        .builder(ClassName.get(EvaluationContext.class), GLOBAL_EVALUATION_CONTEXT_FIELD)
        .addModifiers(PRIVATE, STATIC)
        .build();
  }

  private MethodSpec generateGetValueProviderResolverDeclaration() {
    MethodSpec.Builder methodBuilder = MethodSpec
        .methodBuilder(GET_VALUE_PROVIDER_RESOLVER_DECLARATION_METHOD)
        .returns(
                 ParameterizedTypeName
                     .get(com.mulesoft.connectivity.rest.commons.internal.model.resolvers.ResolverDeclaration.class,
                          ValueProviderResolverDefinition.class))
        .addModifiers(PRIVATE);

    methodBuilder
        .addStatement("$1T builder = new $1T($2L)", ValueProviderResolverDeclarationBuilder.class, RESOLVER_NAME_FIELD);

    CodeBlock.Builder builderBuilder = getValueProviderExpressionBuilder();

    for (ResolverParameter resolverParameter : declaration.getParameters()) {
      String dataType = DataType.fromString(resolverParameter.getType().getName()).name().toUpperCase();
      builderBuilder.add(".parameter($S, p -> p.type($T.$L))", resolverParameter.getName(), DataType.class, dataType);
    }

    methodBuilder
        .addStatement(builderBuilder.build())
        .addStatement("return builder.build()");

    return methodBuilder.build();
  }

  private MethodSpec generateGetGlobalEvaluationContext() {
    MethodSpec.Builder methodBuilder = MethodSpec
        .methodBuilder(GET_GLOBAL_EVALUATION_CONTEXT_METHOD)
        .addModifiers(PROTECTED)
        .returns(ParameterizedTypeName.get(Optional.class, EvaluationContext.class))
        .addAnnotation(Override.class);

    methodBuilder
        .beginControlFlow("if ($L != null)", GLOBAL_EVALUATION_CONTEXT_FIELD)
        .addStatement("return $T.of($L)", Optional.class, GLOBAL_EVALUATION_CONTEXT_FIELD)
        .endControlFlow()
        .addStatement("$L = new $T()", GLOBAL_EVALUATION_CONTEXT_FIELD, SimpleEvaluationContext.class)
        .addStatement("$L.declare($L())", GLOBAL_EVALUATION_CONTEXT_FIELD, GET_VALUE_PROVIDER_RESOLVER_DECLARATION_METHOD)
        .addStatement("return $T.of($L)", Optional.class, GLOBAL_EVALUATION_CONTEXT_FIELD);

    return methodBuilder.build();
  }

  @Override
  protected CodeBlock generateBuildMethodBody() {
    return null;
  }

  @Override
  protected boolean isBoundParameter(ParameterType parameterType, SdkParameter sdkParameter) {
    return false;
  }

  @Override
  public String getJavaClassName() {
    return getJavaUpperCamelNameFromXml(getXmlName(declaration.getName())) + "RestValueProvider";
  }

  public TypeName getTypeName() {
    return ClassName.get(this.getPackage(), this.getJavaClassName());
  }

  @Override
  protected boolean needsConfigureEvaluationContextMethod() {
    return false;
  }
}
