/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.templating.sdk;

import com.google.common.base.CaseFormat;
import com.mulesoft.connectivity.rest.commons.api.error.RestError;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorModel;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.type.schema.TypeSchema;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.util.JavaUtils;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.util.ParserUtils;
import com.mulesoft.connectivity.rest.sdk.templating.JavaTemplateEntity;
import com.mulesoft.connectivity.rest.sdk.templating.api.RestSdkRunConfiguration;
import com.mulesoft.connectivity.rest.sdk.templating.exception.TemplatingException;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.SdkConfig;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.lang.model.element.Modifier;
import org.mule.runtime.api.meta.Category;
import org.mule.runtime.extension.api.annotation.Configurations;
import org.mule.runtime.extension.api.annotation.Extension;
import org.mule.runtime.extension.api.annotation.dsl.xml.Xml;
import org.mule.runtime.extension.api.annotation.error.ErrorTypes;
import org.mule.runtime.extension.api.annotation.license.RequiresEnterpriseLicense;

public class SdkConnector
extends JavaTemplateEntity {
    private final List<SdkConfig> configs;
    private final Map<TypeSchema, String> typeSchemaNames = new HashMap<TypeSchema, String>();
    private final Map<List<String>, String> enumValuesName = new HashMap<List<String>, String>();
    private final Map<String, TypeName> parentValueProviders = new HashMap<String, TypeName>();

    public SdkConnector(Path outputDir, ConnectorModel connectorModel, RestSdkRunConfiguration runConfiguration) throws TemplatingException {
        super(outputDir, connectorModel, runConfiguration);
        this.configs = Stream.of(new SdkConfig(outputDir, connectorModel, this, runConfiguration)).collect(Collectors.toList());
    }

    public String getJavaName() {
        return JavaUtils.getJavaUpperCamelNameFromXml((String)this.connectorModel.getConnectorXmlName());
    }

    private Category getCategory() {
        return this.connectorModel.getCategory() != null ? Category.valueOf((String)this.connectorModel.getCategory().getCategoryName().toUpperCase()) : null;
    }

    @Override
    public void applyTemplates() throws TemplatingException {
        this.generateConnectorClass();
        for (SdkConfig config : this.configs) {
            config.applyTemplates();
        }
    }

    private void generateConnectorClass() throws TemplatingException {
        TypeSpec.Builder connectorClassBuilder = TypeSpec.classBuilder((String)JavaUtils.getJavaUpperCamelNameFromXml((String)this.connectorModel.getConnectorXmlName())).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(this.getExtensionAnnotation()).addAnnotation(this.getXmlAnnotation()).addAnnotation(this.getConfigurationsAnnotation()).addAnnotation(this.getErrorTypesAnnotation());
        if (this.getCategory() != null) {
            connectorClassBuilder.addAnnotation(this.getLicenseAnnotation());
        }
        this.writeClassToFile(connectorClassBuilder.build(), this.connectorModel.getBasePackage() + ".internal.extension");
    }

    private AnnotationSpec getExtensionAnnotation() {
        String extensionName = CaseFormat.LOWER_HYPHEN.to(CaseFormat.UPPER_CAMEL, this.connectorModel.getConnectorXmlName());
        extensionName = ParserUtils.splitCaps((String)extensionName, (String)" ");
        AnnotationSpec.Builder extensionAnnotationBuilder = AnnotationSpec.builder(Extension.class).addMember("name", "$S", new Object[]{extensionName});
        if (this.getCategory() != null) {
            extensionAnnotationBuilder.addMember("category", "$T.$L", new Object[]{Category.class, this.getCategory()});
        }
        return extensionAnnotationBuilder.build();
    }

    private AnnotationSpec getLicenseAnnotation() {
        AnnotationSpec.Builder connectorAnnotationBuilder = AnnotationSpec.builder(RequiresEnterpriseLicense.class).addMember("allowEvaluationLicense", "$L", new Object[]{true});
        return connectorAnnotationBuilder.build();
    }

    private AnnotationSpec getXmlAnnotation() {
        AnnotationSpec.Builder connectorAnnotationBuilder = AnnotationSpec.builder(Xml.class).addMember("prefix", "$S", new Object[]{this.connectorModel.getExtensionXml()});
        return connectorAnnotationBuilder.build();
    }

    private AnnotationSpec getConfigurationsAnnotation() {
        CodeBlock.Builder codeBlock = CodeBlock.builder();
        codeBlock.add("{", new Object[0]);
        for (int i = 0; i < this.configs.size(); ++i) {
            SdkConfig config = this.configs.get(i);
            codeBlock.add("$T.class", new Object[]{ClassName.get((String)config.getPackage(), (String)config.getJavaClassName(), (String[])new String[0])});
            if (i >= this.configs.size() - 1) continue;
            codeBlock.add(",", new Object[0]);
        }
        codeBlock.add("}", new Object[0]);
        AnnotationSpec.Builder configurationsAnnotationBuilder = AnnotationSpec.builder(Configurations.class).addMember("value", codeBlock.build());
        return configurationsAnnotationBuilder.build();
    }

    private AnnotationSpec getErrorTypesAnnotation() {
        return AnnotationSpec.builder(ErrorTypes.class).addMember("value", "$T.class", new Object[]{RestError.class}).build();
    }

    public Map<TypeSchema, String> getTypeSchemaNames() {
        return this.typeSchemaNames;
    }

    public Map<List<String>, String> getEnumValuesName() {
        return this.enumValuesName;
    }

    public Map<String, TypeName> getParentValueProviders() {
        return this.parentValueProviders;
    }
}

