/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.templating.sdk;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorModel;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorOperation;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.type.MultipartTypeDefinition;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.PaginationTypeDescriptor;
import com.mulesoft.connectivity.rest.sdk.templating.api.RestSdkRunConfiguration;
import com.mulesoft.connectivity.rest.sdk.templating.exception.TemplatingException;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.AbstractSdkOperation;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.SdkConnector;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.SdkMarkerPaginationOperation;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.SdkMultipartOperation;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.SdkOffsetPaginationOperation;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.SdkOperation;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.SdkPageNumberPaginationOperation;
import java.nio.file.Path;

public class SdkOperationFactory {
    public static AbstractSdkOperation create(Path outputDir, ConnectorModel connectorModel, SdkConnector sdkConnector, ConnectorOperation operation, RestSdkRunConfiguration runConfiguration) throws TemplatingException {
        if (operation.hasPagination()) {
            PaginationTypeDescriptor pagingType = connectorModel.getPagination(operation.getPagination()).getType();
            if (pagingType.equals((Object)PaginationTypeDescriptor.OFFSET)) {
                return new SdkOffsetPaginationOperation(outputDir, connectorModel, sdkConnector, operation, runConfiguration);
            }
            if (pagingType.equals((Object)PaginationTypeDescriptor.MARKER)) {
                return new SdkMarkerPaginationOperation(outputDir, connectorModel, sdkConnector, operation, runConfiguration);
            }
            if (pagingType.equals((Object)PaginationTypeDescriptor.PAGE_NUMBER)) {
                return new SdkPageNumberPaginationOperation(outputDir, connectorModel, sdkConnector, operation, runConfiguration);
            }
        }
        if (operation.getInputMetadata() instanceof MultipartTypeDefinition) {
            return new SdkMultipartOperation(outputDir, connectorModel, sdkConnector, operation, runConfiguration);
        }
        return new SdkOperation(outputDir, connectorModel, sdkConnector, operation, runConfiguration);
    }
}

