/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.templating.sdk;

import com.mulesoft.connectivity.rest.commons.api.data.sample.RestSampleDataProvider;
import com.mulesoft.connectivity.rest.commons.api.source.RequestParameterBinding;
import com.mulesoft.connectivity.rest.commons.internal.util.RestRequestBuilder;
import com.mulesoft.connectivity.rest.commons.internal.util.RestSdkUtils;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorModel;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorOperation;
import com.mulesoft.connectivity.rest.sdk.templating.JavaTemplateEntity;
import com.mulesoft.connectivity.rest.sdk.templating.api.RestSdkRunConfiguration;
import com.mulesoft.connectivity.rest.sdk.templating.exception.TemplatingException;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.AbstractSdkOperation;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.SdkParameter;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.WildcardTypeName;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.Modifier;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.sdk.api.annotation.param.Parameter;

public class SdkSampleDataProvider
extends JavaTemplateEntity {
    private static final String GET_TYPED_VALUE_OR_NULL_METHOD = "getTypedValueOrNull";
    private static final String GET_PATH_TEMPLATE_METHOD = "getPathTemplate";
    private static final String GET_REQUEST_BUILDER_METHOD = "getRequestBuilder";
    private static final String GET_PARAMETER_BINDING_METHOD = "getParameterBinding";
    private static final String PARAMETER_BINDING_LOCAL_VARIABLE = "binding";
    private static final String ADD_URI_BINDING_METHOD = "addUriParamBinding";
    private static final String ADD_QUERY_BINDING_METHOD = "addQueryParamBinding";
    private static final String ADD_HEADER_BINDING_METHOD = "addHeaderBinding";
    private static final String GET_PARAMETER_VALUES_METHOD = "getParameterValues";
    private static final String PATH_TEMPLATE_FIELD = "PATH";
    private final AbstractSdkOperation sdkOperation;
    private final ConnectorOperation operation;
    private final String javaClassName;
    private final String aPackage;
    private final AbstractSdkOperation.MessageOutputType messageOutputType;
    private Map<String, SdkParameter> operationParameters = null;

    public SdkSampleDataProvider(Path outputDir, ConnectorModel connectorModel, AbstractSdkOperation sdkOperation, ConnectorOperation operation, RestSdkRunConfiguration runConfiguration) {
        super(outputDir, connectorModel, runConfiguration);
        this.sdkOperation = sdkOperation;
        this.operation = operation;
        this.javaClassName = sdkOperation.getJavaClassName();
        this.aPackage = sdkOperation.getPackage();
        this.messageOutputType = sdkOperation.getMessageOutputType();
    }

    @Override
    public void applyTemplates() throws TemplatingException {
        this.generateSampleDataClass();
    }

    public String getPackage() {
        return this.aPackage + ".sample.data";
    }

    public String getJavaClassName() {
        return this.javaClassName + "SampleDataProvider";
    }

    private void generateSampleDataClass() throws TemplatingException {
        TypeSpec.Builder sampleDataClassBuilder = TypeSpec.classBuilder((String)this.getJavaClassName()).addModifiers(new Modifier[]{Modifier.PUBLIC}).superclass((TypeName)this.getSuperclass()).addMethod(this.generateConstructor()).addMethod(this.generateGetPathTemplateMethod()).addMethod(this.generateGetRequestBuilderMethod()).addMethod(this.generateGetParameterBindingMethod()).addMethod(this.generateGetParameterValuesMethod());
        this.addClassConstants(sampleDataClassBuilder);
        this.addParameters(sampleDataClassBuilder);
        JavaFile.Builder javaFileBuilder = this.getJavaFileBuilderForClass(sampleDataClassBuilder.build(), this.getPackage());
        javaFileBuilder.addStaticImport(RestSdkUtils.class, new String[]{GET_TYPED_VALUE_OR_NULL_METHOD});
        this.writeJavaFile(javaFileBuilder.build());
    }

    private ParameterizedTypeName getSuperclass() {
        TypeName outputType = this.messageOutputType.getOutputType();
        TypeName attributeOutputType = this.messageOutputType.getAttributeOutputType();
        return ParameterizedTypeName.get((ClassName)ClassName.get(RestSampleDataProvider.class), (TypeName[])new TypeName[]{outputType, attributeOutputType});
    }

    private MethodSpec generateConstructor() {
        MethodSpec.Builder constructorBuilder = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC});
        return constructorBuilder.build();
    }

    private MethodSpec generateGetPathTemplateMethod() {
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)GET_PATH_TEMPLATE_METHOD).addModifiers(new Modifier[]{Modifier.PROTECTED}).returns(String.class).addAnnotation(Override.class);
        methodBuilder.addStatement("return $L", new Object[]{PATH_TEMPLATE_FIELD});
        return methodBuilder.build();
    }

    private MethodSpec generateGetRequestBuilderMethod() {
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)GET_REQUEST_BUILDER_METHOD).addModifiers(new Modifier[]{Modifier.PROTECTED}).returns(RestRequestBuilder.class).addAnnotation(Override.class).addParameter(String.class, "path", new Modifier[0]);
        methodBuilder.addStatement("return new $T(connection.getBaseUri(), path, $T.$L)", new Object[]{RestRequestBuilder.class, HttpConstants.Method.class, this.operation.getHttpMethod().toUpperCase()});
        return methodBuilder.build();
    }

    private MethodSpec generateGetParameterBindingMethod() {
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)GET_PARAMETER_BINDING_METHOD).addModifiers(new Modifier[]{Modifier.PROTECTED}).returns(RequestParameterBinding.class).addAnnotation(Override.class);
        Map<String, SdkParameter> parameters = this.getOperationSampleDataParameters();
        if (!parameters.isEmpty()) {
            methodBuilder.addStatement("$1T $2L = new $1T()", new Object[]{RequestParameterBinding.class, PARAMETER_BINDING_LOCAL_VARIABLE});
            this.addParameter(methodBuilder, this.sdkOperation.allQueryParameters, ADD_QUERY_BINDING_METHOD);
            this.addParameter(methodBuilder, this.sdkOperation.allPathParameters, ADD_URI_BINDING_METHOD);
            this.addParameter(methodBuilder, this.sdkOperation.allHeaders, ADD_HEADER_BINDING_METHOD);
            methodBuilder.addStatement("return $1L", new Object[]{PARAMETER_BINDING_LOCAL_VARIABLE});
        } else {
            methodBuilder.addStatement("return new $1T()", new Object[]{RequestParameterBinding.class});
        }
        return methodBuilder.build();
    }

    private void addParameter(MethodSpec.Builder methodBuilder, List<SdkParameter> parameters, String bindingMethod) {
        for (SdkParameter sdkParameter : parameters) {
            methodBuilder.addStatement("$L.$L($S, $L)", new Object[]{PARAMETER_BINDING_LOCAL_VARIABLE, bindingMethod, sdkParameter.getExternalName(), sdkParameter.getStringValueGetter()});
        }
    }

    private MethodSpec generateGetParameterValuesMethod() {
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)GET_PARAMETER_VALUES_METHOD).addModifiers(new Modifier[]{Modifier.PROTECTED}).returns((TypeName)this.getParameterValuesMultiMapType()).addAnnotation(Override.class);
        methodBuilder.addStatement("return new $T()", new Object[]{this.getParameterValuesMultiMapType()});
        return methodBuilder.build();
    }

    private Map<String, SdkParameter> getOperationSampleDataParameters() {
        if (this.operationParameters != null) {
            return this.operationParameters;
        }
        HashMap<String, SdkParameter> operationParameters = new HashMap<String, SdkParameter>();
        for (SdkParameter sdkParameter : this.sdkOperation.allQueryParameters) {
            operationParameters.put(sdkParameter.getJavaName(), sdkParameter);
        }
        for (SdkParameter sdkParameter : this.sdkOperation.allPathParameters) {
            operationParameters.put(sdkParameter.getJavaName(), sdkParameter);
        }
        for (SdkParameter sdkParameter : this.sdkOperation.allHeaders) {
            operationParameters.put(sdkParameter.getJavaName(), sdkParameter);
        }
        this.operationParameters = operationParameters;
        return this.operationParameters;
    }

    private ParameterizedTypeName getParameterValuesMultiMapType() {
        ParameterizedTypeName wildcardTypedValueType = ParameterizedTypeName.get((ClassName)ClassName.get(TypedValue.class), (TypeName[])new TypeName[]{WildcardTypeName.subtypeOf(Object.class)});
        return ParameterizedTypeName.get((ClassName)ClassName.get(MultiMap.class), (TypeName[])new TypeName[]{ClassName.get(String.class), wildcardTypedValueType});
    }

    private void addClassConstants(TypeSpec.Builder sampleDataClassBuilder) {
        sampleDataClassBuilder.addField(this.getConstantStringField(PATH_TEMPLATE_FIELD, this.operation.getPath()));
    }

    private void addParameters(TypeSpec.Builder sampleDataClassBuilder) {
        Map<String, SdkParameter> operationSdkParameters = this.getOperationSampleDataParameters();
        for (String parameterName : operationSdkParameters.keySet()) {
            sampleDataClassBuilder.addField(this.getParameterFieldSpec(operationSdkParameters.get(parameterName)));
        }
    }

    private FieldSpec getParameterFieldSpec(SdkParameter sdkParameter) {
        FieldSpec.Builder fieldBuilder = FieldSpec.builder((TypeName)sdkParameter.getTypeName(), (String)sdkParameter.getJavaName(), (Modifier[])new Modifier[]{Modifier.PRIVATE}).addAnnotation(Parameter.class);
        return fieldBuilder.build();
    }
}

