/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.templating;

import com.google.googlejavaformat.java.Formatter;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorModel;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.util.JavaUtils;
import com.mulesoft.connectivity.rest.sdk.templating.TemplateEntity;
import com.mulesoft.connectivity.rest.sdk.templating.api.RestSdkRunConfiguration;
import com.mulesoft.connectivity.rest.sdk.templating.exception.TemplatingException;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.SdkConnector;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.SdkGitIgnore;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.SdkPom;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.SdkTestLog4j;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SdkConnectorTemplateEntity
extends TemplateEntity {
    private static final Logger LOGGER = LogManager.getLogger(SdkConnectorTemplateEntity.class);
    private static final Formatter FORMATTER = new Formatter();
    private final SdkConnector sdkConnector;
    private final SdkPom sdkPom;
    private final SdkTestLog4j sdkTestLog4j;
    private final Path projectDir;
    private final Path descriptorPath;
    private final SdkGitIgnore sdkGitIgnore;
    private final RestSdkRunConfiguration runConfiguration;

    public SdkConnectorTemplateEntity(Path outputDir, ConnectorModel connectorModel, Path descriptorPath, RestSdkRunConfiguration runConfiguration) throws TemplatingException {
        String projectName = JavaUtils.getJavaUpperCamelNameFromXml((String)connectorModel.getConnectorXmlName());
        this.projectDir = outputDir.resolve(projectName);
        this.checkValidProjectDir(this.projectDir);
        this.sdkConnector = new SdkConnector(this.projectDir, connectorModel, runConfiguration);
        this.sdkPom = new SdkPom(this.projectDir, connectorModel);
        this.descriptorPath = descriptorPath;
        this.sdkGitIgnore = new SdkGitIgnore(this.projectDir);
        this.sdkTestLog4j = new SdkTestLog4j(this.projectDir);
        this.runConfiguration = runConfiguration;
    }

    private void checkValidProjectDir(Path directory) throws TemplatingException {
        String[] children;
        File dirFile = directory.toFile();
        if (dirFile.exists() && dirFile.isDirectory() && (children = dirFile.list()) != null && children.length > 0) {
            throw new TemplatingException(String.format("Output directory is not empty: %s", this.projectDir.toString()));
        }
        LOGGER.info("Project output directory: " + this.projectDir.toString());
    }

    @Override
    public void applyTemplates() throws TemplatingException {
        this.sdkConnector.applyTemplates();
        this.sdkPom.applyTemplates();
        this.sdkGitIgnore.applyTemplates();
        this.sdkTestLog4j.applyTemplates();
        this.formatJavaFiles();
        this.addDescriptorToSources();
    }

    protected void addDescriptorToSources() throws TemplatingException {
        if (this.descriptorPath != null) {
            try (FileInputStream descriptorStream = new FileInputStream(this.descriptorPath.toFile());){
                Files.copy(descriptorStream, this.sdkConnector.getSourcesPath().resolve("connector-descriptor.yaml"), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException e) {
                throw new TemplatingException("Could not add descriptor to generated sources");
            }
        }
    }

    private void formatJavaFiles() throws TemplatingException {
        for (Path path : this.getJavaFiles()) {
            this.javaFormat(path);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<Path> getJavaFiles() throws TemplatingException {
        try (Stream<Path> paths = Files.find(this.projectDir, Integer.MAX_VALUE, (filePath, fileAttr) -> filePath.toString().toLowerCase().endsWith(".java"), new FileVisitOption[0]);){
            List<Path> list = paths.collect(Collectors.toList());
            return list;
        }
        catch (Exception e) {
            throw new TemplatingException("Could not find files to format", e);
        }
    }

    private void javaFormat(Path filepath) throws TemplatingException {
        try {
            String content = new String(Files.readAllBytes(filepath), StandardCharsets.UTF_8);
            String formattedSource = FORMATTER.formatSource(content);
            Files.delete(filepath);
            Files.write(filepath, formattedSource.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        catch (Exception e) {
            throw new TemplatingException("Could not format file " + filepath.toString(), e);
        }
    }
}

