/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.templating.api;

public class RestSdkRunConfiguration {

  private final boolean skipValidations;
  private final boolean useDynamicTypeResolvers;
  private final boolean disambiguateContentParameters;

  private RestSdkRunConfiguration(boolean skipValidations,
                                  boolean useDynamicTypeResolvers,
                                  boolean disambiguateContentParameters) {
    this.skipValidations = skipValidations;
    this.useDynamicTypeResolvers = useDynamicTypeResolvers;
    this.disambiguateContentParameters = disambiguateContentParameters;
  }

  public static Builder builder() {
    return new Builder();
  }

  public boolean skipValidations() {
    return skipValidations;
  }

  public boolean useDynamicTypeResolvers() {
    return useDynamicTypeResolvers;
  }

  public boolean disambiguateContentParameters() {
    return disambiguateContentParameters;
  }

  public static class Builder {

    private boolean skipValidations = false;
    private boolean useDynamicTypeResolvers = false;
    private boolean disambiguateContentParameters = true;

    public RestSdkRunConfiguration build() {
      return new RestSdkRunConfiguration(skipValidations,
                                         useDynamicTypeResolvers,
                                         disambiguateContentParameters);
    }

    public Builder skipValidations(boolean skipValidations) {
      this.skipValidations = skipValidations;
      return this;
    }

    public Builder useDynamicTypeResolvers(boolean useDynamicTypeResolvers) {
      this.useDynamicTypeResolvers = useDynamicTypeResolvers;
      return this;
    }

    public Builder disambiguateContentParameters(boolean disambiguateContentParameters) {
      this.disambiguateContentParameters = disambiguateContentParameters;
      return this;
    }
  }
}
