/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.templating.sdk.valueprovider;

import static com.mulesoft.connectivity.rest.sdk.internal.connectormodel.util.JavaUtils.getJavaUpperCamelNameFromXml;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorModel;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter.Parameter;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.resolver.ResolverReference;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.valueprovider.ValueProviderDefinition;
import com.mulesoft.connectivity.rest.sdk.templating.api.RestSdkRunConfiguration;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.SdkConnector;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.operation.AbstractSdkOperation;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.parameter.SdkParameter;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.resolver.AbstractSdkResolverProviderReference;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.resolver.AbstractSdkResolverProviderReferenceParent;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.resolver.SdkResolverDefinition;

import com.squareup.javapoet.TypeName;

import java.nio.file.Path;
import java.util.List;
import java.util.Map;

public class SdkValueProviderReference extends AbstractSdkResolverProviderReference {

  private final Parameter parameter;
  private final SdkConnector sdkConnector;

  private final AbstractSdkOperation sdkOperation;
  private final ResolverReference<ValueProviderDefinition> reference;
  private final SdkResolverDefinition<ValueProviderDefinition> sdkResolverDefinition;


  public SdkValueProviderReference(Path outputDir,
                                   ConnectorModel connectorModel,
                                   SdkConnector sdkConnector,
                                   AbstractSdkOperation sdkOperation,
                                   Parameter parameter,
                                   ResolverReference<ValueProviderDefinition> reference,
                                   SdkResolverDefinition<ValueProviderDefinition> sdkResolverDefinition,
                                   RestSdkRunConfiguration runConfiguration) {
    super(outputDir, connectorModel, reference, sdkResolverDefinition, runConfiguration);
    this.parameter = parameter;
    this.sdkConnector = sdkConnector;
    this.sdkOperation = sdkOperation;
    this.reference = reference;
    this.sdkResolverDefinition = sdkResolverDefinition;
  }

  public String getPackage() {
    return connectorModel.getBasePackage() + ".internal.metadata.values";
  }

  public String getJavaClassName() {
    return sdkOperation.getJavaClassName() + getJavaUpperCamelNameFromXml(parameter.getInternalName()) + "ValueProvider";
  }

  @Override
  protected List<SdkParameter> getAllParameters() {
    return sdkOperation.getAllParameters();
  }

  @Override
  protected String getEvaluationContextKind() {
    return sdkResolverDefinition.getEvaluationContextKind();
  }

  @Override
  protected Map<String, TypeName> getAllParents() {
    return sdkConnector.getParentValueProviders();
  }

  @Override
  protected AbstractSdkResolverProviderReferenceParent getNewParent() {
    return new SdkValueProviderReferenceParent(outputDir,
                                               connectorModel,
                                               sdkOperation,
                                               reference,
                                               sdkResolverDefinition,
                                               runConfiguration);
  }
}
