/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.templating.sdk.operation;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorModel;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorOperation;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter.Parameter;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter.ParameterType;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter.PartParameter;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.type.MultipartTypeDefinition;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.type.TypeDefinition;
import com.mulesoft.connectivity.rest.sdk.templating.api.RestSdkRunConfiguration;
import com.mulesoft.connectivity.rest.sdk.templating.exception.TemplatingException;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.SdkConnector;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.operation.SdkOperation;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.parameter.SdkContent;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.parameter.SdkParameter;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.MethodSpec;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;

public class SdkMultipartOperation
extends SdkOperation {
    private final List<SdkMultipartPart> sdkParts;

    public SdkMultipartOperation(Path outputDir, ConnectorModel connectorModel, SdkConnector sdkConnector, ConnectorOperation operation, RestSdkRunConfiguration runConfiguration) throws TemplatingException {
        super(outputDir, connectorModel, sdkConnector, operation, runConfiguration);
        MultipartTypeDefinition multipartContent = (MultipartTypeDefinition)operation.getInputMetadata();
        this.sdkParts = this.buildSdkMultipartParts(outputDir, connectorModel, sdkConnector, operation, multipartContent);
    }

    protected List<SdkMultipartPart> buildSdkMultipartParts(Path outputDir, ConnectorModel connectorModel, SdkConnector sdkConnector, ConnectorOperation operation, MultipartTypeDefinition multipartContent) throws TemplatingException {
        ArrayList<SdkMultipartPart> parts = new ArrayList<SdkMultipartPart>();
        boolean primary = true;
        for (PartParameter partParameter : multipartContent.getParts()) {
            SdkContent partContent = new SdkContent(outputDir, connectorModel, sdkConnector, operation, partParameter.getTypeDefinition(), SdkContent.SdkContentKind.PART, partParameter.getExternalName(), primary, this.runConfiguration);
            SdkParameter filenameParameter = partParameter.isFilePart() ? new SdkParameter(outputDir, connectorModel, sdkConnector, this.getJavaClassName(), this.getFilenameParameter(partParameter), this, this.runConfiguration) : null;
            SdkMultipartPart sdkMultipartPart = new SdkMultipartPart(partParameter, partContent, filenameParameter);
            parts.add(sdkMultipartPart);
            primary = false;
        }
        return parts;
    }

    private Parameter getFilenameParameter(PartParameter partParameter) {
        return new Parameter(partParameter.getDisplayName() + " Filename", partParameter.getExternalName() + "-part-filename", ParameterType.PART, TypeDefinition.simpleStringType(), "The name of the file being sent in the '" + partParameter.getDisplayName() + "' part. (just the name, do not include path).", true, null, false, null, new LinkedList());
    }

    @Override
    protected void addSetBodyMethod(CodeBlock.Builder methodBody) {
        methodBody.add(".setBody(body, overrides.getStreamingType())", new Object[0]);
    }

    @Override
    public CodeBlock generateOperationMethodBody() {
        CodeBlock consumerBody = this.generateOperationMethodBody("multipartCallback");
        return CodeBlock.builder().add("withMultipart(builder -> $L , callback, (body, multipartCallback) -> { $L });", new Object[]{this.generateMultipartBuilderCodeBlock(), consumerBody}).build();
    }

    protected CodeBlock generateMultipartBuilderCodeBlock() {
        CodeBlock.Builder multipartBuilderCodeBlockBuilder = CodeBlock.builder().add("builder", new Object[0]);
        if (!this.sdkParts.isEmpty()) {
            for (SdkMultipartPart sdkPart : this.sdkParts) {
                if (sdkPart.getPartParameter().isFilePart()) {
                    multipartBuilderCodeBlockBuilder.add(".addFilePart($S, $L, $L)", new Object[]{sdkPart.getPartParameter().getExternalName(), sdkPart.getPartFilename().getStringValueGetter(), sdkPart.getPartContent().getContentParameterJavaName()});
                    continue;
                }
                multipartBuilderCodeBlockBuilder.add(".addPart($S, $L)", new Object[]{sdkPart.getPartParameter().getExternalName(), sdkPart.getPartContent().getContentParameterJavaName()});
            }
            multipartBuilderCodeBlockBuilder.add(".setBoundary(\"__rc2_34b212\")", new Object[0]);
        }
        return multipartBuilderCodeBlockBuilder.build();
    }

    @Override
    protected void addContentParameters(CodeBlock.Builder javaDoc, MethodSpec.Builder methodBuilder) {
        for (SdkMultipartPart sdkPart : this.sdkParts) {
            methodBuilder.addParameter(sdkPart.getPartContent().generateContentParameter());
            javaDoc.add("@param $L $L\n", new Object[]{sdkPart.getPartContent().getContentParameterJavaName(), "The content of the '" + sdkPart.getPartParameter().getDisplayName() + "' part."});
            if (sdkPart.getPartFilename() == null) continue;
            methodBuilder.addParameter(sdkPart.getPartFilename().generateParameterParameter().build());
            javaDoc.add("@param $L $L\n", new Object[]{sdkPart.getPartFilename().getJavaName(), "The filename of the '" + sdkPart.getPartParameter().getDisplayName() + "' part (just the name, do not include path)."});
        }
    }

    @Override
    protected SdkContent buildContent(Path outputDir, ConnectorModel connectorModel, SdkConnector sdkConnector, ConnectorOperation operation) {
        return null;
    }

    @Override
    public void applyTemplates() throws TemplatingException {
        for (SdkMultipartPart sdkPart : this.sdkParts) {
            sdkPart.getPartContent().applyTemplates();
            if (sdkPart.getPartFilename() == null) continue;
            sdkPart.getPartFilename().applyTemplates();
        }
        super.applyTemplates();
    }

    private static class SdkMultipartPart {
        private final PartParameter partParameter;
        private final SdkContent partContent;
        private final SdkParameter partFilename;

        SdkMultipartPart(PartParameter partParameter, SdkContent partContent, @Nullable SdkParameter partFilename) {
            this.partParameter = partParameter;
            this.partContent = partContent;
            this.partFilename = partFilename;
        }

        public PartParameter getPartParameter() {
            return this.partParameter;
        }

        public SdkContent getPartContent() {
            return this.partContent;
        }

        public SdkParameter getPartFilename() {
            return this.partFilename;
        }
    }
}

