/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.templating.sdk.operation;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorModel;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorOperation;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.type.MultipartTypeDefinition;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.PaginationTypeDescriptor;
import com.mulesoft.connectivity.rest.sdk.templating.api.RestSdkRunConfiguration;
import com.mulesoft.connectivity.rest.sdk.templating.exception.TemplatingException;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.SdkConnector;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.operation.AbstractSdkOperation;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.operation.SdkMarkerPaginationOperation;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.operation.SdkMultipartOperation;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.operation.SdkOffsetPaginationOperation;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.operation.SdkOperation;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.operation.SdkPageNumberPaginationOperation;
import java.nio.file.Path;

public class SdkOperationFactory {
    public static AbstractSdkOperation create(Path outputDir, ConnectorModel connectorModel, SdkConnector sdkConnector, ConnectorOperation operation, RestSdkRunConfiguration runConfiguration) throws TemplatingException {
        if (operation.hasPagination()) {
            PaginationTypeDescriptor pagingType = operation.getPagination().getType();
            if (pagingType.equals((Object)PaginationTypeDescriptor.OFFSET)) {
                return new SdkOffsetPaginationOperation(outputDir, connectorModel, sdkConnector, operation, runConfiguration);
            }
            if (pagingType.equals((Object)PaginationTypeDescriptor.MARKER)) {
                return new SdkMarkerPaginationOperation(outputDir, connectorModel, sdkConnector, operation, runConfiguration);
            }
            if (pagingType.equals((Object)PaginationTypeDescriptor.PAGE_NUMBER)) {
                return new SdkPageNumberPaginationOperation(outputDir, connectorModel, sdkConnector, operation, runConfiguration);
            }
        }
        if (operation.getInputMetadata() instanceof MultipartTypeDefinition) {
            return new SdkMultipartOperation(outputDir, connectorModel, sdkConnector, operation, runConfiguration);
        }
        return new SdkOperation(outputDir, connectorModel, sdkConnector, operation, runConfiguration);
    }
}

