/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.templating.sdk.operation;

import com.google.common.base.CaseFormat;
import com.mulesoft.connectivity.rest.commons.api.configuration.RestConfiguration;
import com.mulesoft.connectivity.rest.commons.api.connection.RestConnection;
import com.mulesoft.connectivity.rest.commons.api.error.RequestErrorTypeProvider;
import com.mulesoft.connectivity.rest.commons.api.operation.BaseRestOperation;
import com.mulesoft.connectivity.rest.commons.api.operation.ConfigurationOverrides;
import com.mulesoft.connectivity.rest.commons.api.operation.EntityRequestParameters;
import com.mulesoft.connectivity.rest.commons.api.operation.HttpResponseAttributes;
import com.mulesoft.connectivity.rest.commons.api.operation.NonEntityRequestParameters;
import com.mulesoft.connectivity.rest.commons.internal.RestConstants;
import com.mulesoft.connectivity.rest.commons.internal.util.RestRequestBuilder;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorModel;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorOperation;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.pagination.Pagination;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter.Parameter;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.resolver.ResolverExpression;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.resolver.ResolverReference;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.sampledata.SampleDataDefinition;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.util.JavaUtils;
import com.mulesoft.connectivity.rest.sdk.templating.JavaTemplateEntity;
import com.mulesoft.connectivity.rest.sdk.templating.api.RestSdkRunConfiguration;
import com.mulesoft.connectivity.rest.sdk.templating.exception.TemplatingException;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.SdkConnector;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.metadata.SdkOutputMetadataResolver;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.metadata.SdkPagingMetadataResolver;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.munit.SdkMtfOperationTest;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.parameter.SdkContent;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.parameter.SdkPaginationParameter;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.parameter.SdkParameter;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.resolver.AbstractSdkResolverProvider;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.sampledata.SdkSampleDataDefinition;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.sampledata.SdkSampleDataInline;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.sampledata.SdkSampleDataReference;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.lang.model.element.Modifier;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.extension.api.annotation.error.Throws;
import org.mule.runtime.extension.api.annotation.metadata.OutputResolver;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.extension.api.runtime.process.CompletionCallback;
import org.mule.runtime.extension.api.runtime.streaming.StreamingHelper;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.sdk.api.annotation.data.sample.SampleData;

public abstract class AbstractSdkOperation
extends JavaTemplateEntity {
    public static final String PARAM_DOC_NAME_DESCRIPTION = "@param $L $L\n";
    public static final String CONTENT_TYPE_HEADER_NAME = "content-type";
    public static final String ACCEPT_HEADER_NAME = "accept";
    public static final String ADD_QUERY_PARAM_METHOD_NAME = "addQueryParam";
    public static final String ADD_HEADER_METHOD_NAME = "addHeader";
    public static final String ADD_MULTIPLE_QUERY_PARAM_METHOD_NAME = "addQueryParams";
    public static final String ADD_MULTIPLE_HEADER_METHOD_NAME = "addHeaders";
    private static final String REQUEST_PARAMETERS_GROUP_NAME = "REQUEST_PARAMETERS_GROUP_NAME";
    private static final String CONNECTOR_OVERRIDES = "CONNECTOR_OVERRIDES";
    private static final String QUERY_PARAM_FORMAT_FIELD = "QUERY_PARAM_FORMAT";
    private final ConnectorOperation operation;
    private final SdkConnector sdkConnector;
    protected final List<SdkParameter> allPathParameters;
    protected final List<SdkParameter> allQueryParameters;
    protected final List<SdkParameter> allHeaders;
    protected final SdkContent content;
    protected final SdkOutputMetadataResolver outputMetadataResolver;
    protected final AbstractSdkResolverProvider sampleDataProvider;
    private final SdkMtfOperationTest sdkMtfOperationTest;

    public abstract FieldSpec generateExpressionLanguageField();

    public abstract TypeName generateMethodReturn();

    public abstract CodeBlock generateOperationMethodBody() throws TemplatingException;

    public AbstractSdkOperation(Path outputDir, ConnectorModel connectorModel, SdkConnector sdkConnector, ConnectorOperation operation, RestSdkRunConfiguration runConfiguration) throws TemplatingException {
        super(outputDir, connectorModel, runConfiguration);
        this.operation = operation;
        this.sdkConnector = sdkConnector;
        this.allPathParameters = this.buildSdkParameters(outputDir, connectorModel, sdkConnector, operation.getUriParameters(), false);
        this.allQueryParameters = this.buildSdkParameters(outputDir, connectorModel, sdkConnector, operation.getQueryParameters(), true);
        this.allHeaders = this.buildSdkParameters(outputDir, connectorModel, sdkConnector, operation.getHeaders(), false);
        this.content = this.buildContent(outputDir, connectorModel, sdkConnector, operation);
        this.outputMetadataResolver = this.buildOutputMetadataResolver(sdkConnector);
        this.sdkMtfOperationTest = new SdkMtfOperationTest(operation, outputDir);
        this.sampleDataProvider = this.buildSdkSampleDataProvider(operation);
    }

    private AbstractSdkResolverProvider buildSdkSampleDataProvider(ConnectorOperation operation) {
        if (operation.getSampleData() instanceof SampleDataDefinition) {
            return new SdkSampleDataInline(this.outputDir, this.connectorModel, this.getJavaClassName(), this.getAllParameters(), new SdkSampleDataDefinition((ResolverExpression<SampleDataDefinition>)operation.getSampleData(), false, operation.hasPagination()), this.runConfiguration);
        }
        if (operation.getSampleData() instanceof ResolverReference) {
            return new SdkSampleDataReference(this.outputDir, this.connectorModel, this.sdkConnector, this.getJavaClassName(), this.getAllParameters(), (ResolverReference<SampleDataDefinition>)((ResolverReference)operation.getSampleData()), new SdkSampleDataDefinition((ResolverExpression<SampleDataDefinition>)operation.getSampleData(), false, operation.hasPagination()), this.runConfiguration);
        }
        return null;
    }

    private List<SdkParameter> buildSdkParameters(Path outputDir, ConnectorModel connectorModel, SdkConnector sdkConnector, List<Parameter> connectorParameters, boolean checkPaginationParameters) throws TemplatingException {
        ArrayList<SdkParameter> list = new ArrayList<SdkParameter>();
        for (Parameter parameter : connectorParameters) {
            if (checkPaginationParameters && this.isQueryParamDefinedInPagination(parameter.getExternalName())) {
                Pagination pagination = this.getPagination();
                list.add(new SdkPaginationParameter(outputDir, connectorModel, sdkConnector, this.getJavaClassName(), parameter, this, this.runConfiguration, pagination));
                continue;
            }
            list.add(new SdkParameter(outputDir, connectorModel, sdkConnector, this.getJavaClassName(), parameter, this, this.runConfiguration));
        }
        return list;
    }

    private SdkOutputMetadataResolver buildOutputMetadataResolver(SdkConnector sdkConnector) throws TemplatingException {
        if (this.operation.getOutputMetadata() == null) {
            return null;
        }
        if (this.operation.hasPagination()) {
            return new SdkPagingMetadataResolver(this.outputDir, this.connectorModel, sdkConnector, this.operation, this.operation.getOutputMetadata(), this.runConfiguration);
        }
        return new SdkOutputMetadataResolver(this.outputDir, this.connectorModel, sdkConnector, this.operation, this.operation.getOutputMetadata(), "", this.runConfiguration);
    }

    protected SdkContent buildContent(Path outputDir, ConnectorModel connectorModel, SdkConnector sdkConnector, ConnectorOperation operation) throws TemplatingException {
        return operation.getInputMetadata() != null ? new SdkContent(outputDir, connectorModel, sdkConnector, operation, this.runConfiguration) : null;
    }

    public String getJavaClassName() {
        return JavaUtils.getJavaUpperCamelNameFromXml((String)this.operation.getInternalName()) + "Operation";
    }

    private String getJavaMethodName() {
        return JavaUtils.getJavaLowerCamelNameFromXml((String)this.operation.getInternalName());
    }

    public String getPackage() {
        return this.connectorModel.getBasePackage() + ".internal.operation";
    }

    @Override
    public void applyTemplates() throws TemplatingException {
        if (this.content != null) {
            this.content.applyTemplates();
        }
        if (this.outputMetadataResolver != null) {
            this.outputMetadataResolver.applyTemplates();
        }
        for (SdkParameter sdkParameter : this.allPathParameters) {
            sdkParameter.applyTemplates();
        }
        for (SdkParameter sdkParameter : this.allQueryParameters) {
            sdkParameter.applyTemplates();
        }
        for (SdkParameter sdkParameter : this.allHeaders) {
            sdkParameter.applyTemplates();
        }
        this.sdkMtfOperationTest.applyTemplates();
        if (this.sampleDataProvider != null) {
            this.sampleDataProvider.applyTemplates();
        }
        this.generateOperationClass();
    }

    protected void generateOperationClass() throws TemplatingException {
        TypeSpec.Builder operationClassBuilder = TypeSpec.classBuilder((String)this.getJavaClassName()).addModifiers(new Modifier[]{Modifier.PUBLIC}).superclass(BaseRestOperation.class).addMethod(this.generateOperationMethod());
        FieldSpec expressionLanguage = this.generateExpressionLanguageField();
        if (expressionLanguage != null) {
            operationClassBuilder.addField(expressionLanguage);
        }
        for (SdkParameter pathParam : this.allPathParameters) {
            operationClassBuilder.addField(this.generatePathParamPatternField(pathParam));
        }
        operationClassBuilder.addField(this.generateQueryParamFormatField());
        JavaFile.Builder javaFileBuilder = JavaFile.builder((String)this.getPackage(), (TypeSpec)operationClassBuilder.build()).skipJavaLangImports(true).addStaticImport(RestConstants.class, new String[]{REQUEST_PARAMETERS_GROUP_NAME, CONNECTOR_OVERRIDES});
        if (!this.allPathParameters.isEmpty()) {
            javaFileBuilder.addStaticImport(Pattern.class, new String[]{"compile"});
        }
        this.writeJavaFile(javaFileBuilder.build());
    }

    private FieldSpec generateQueryParamFormatField() {
        return FieldSpec.builder(RestRequestBuilder.QueryParamFormat.class, (String)QUERY_PARAM_FORMAT_FIELD, (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.FINAL, Modifier.STATIC}).initializer("$T.$L", new Object[]{RestRequestBuilder.QueryParamFormat.class, this.operation.getQueryParamArrayFormat().name()}).build();
    }

    private FieldSpec generatePathParamPatternField(SdkParameter pathParam) {
        return FieldSpec.builder(Pattern.class, (String)this.getPathParamPatternFieldName(pathParam), (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.FINAL, Modifier.STATIC}).initializer("compile(\"\\\\{$L}\")", new Object[]{pathParam.getExternalName()}).build();
    }

    private String getPathParamPatternFieldName(SdkParameter pathParam) {
        return CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, pathParam.getJavaName()) + "_PATTERN";
    }

    private AnnotationSpec generateDescriptionAnnotation() {
        return AnnotationSpec.builder(Summary.class).addMember("value", "$S", new Object[]{JavaUtils.abbreviateText((String)this.operation.getDescription())}).build();
    }

    public MethodSpec generateOperationMethod() throws TemplatingException {
        ParameterSpec parameterSpec;
        CodeBlock.Builder javaDoc = CodeBlock.builder().add("\n$L\n", new Object[]{StringUtils.defaultIfEmpty((CharSequence)this.operation.getDescription(), (CharSequence)this.operation.getDisplayName())}).add("\nThis operation makes an HTTP $L request to the $L endpoint", new Object[]{this.operation.getHttpMethod().toUpperCase(), this.operation.getPath()}).add("\n", new Object[0]);
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)this.getJavaMethodName()).addModifiers(new Modifier[]{Modifier.PUBLIC});
        ParameterSpec configParameter = this.generateConfigParameter();
        javaDoc.add(PARAM_DOC_NAME_DESCRIPTION, new Object[]{configParameter.name, "the configuration to use"});
        methodBuilder.addParameter(configParameter);
        if (this.requiresConnectionParameter()) {
            ParameterSpec connectionParameter = this.generateConnectionParameter();
            javaDoc.add(PARAM_DOC_NAME_DESCRIPTION, new Object[]{connectionParameter.name, "the connection to use"});
            methodBuilder.addParameter(connectionParameter);
        }
        for (SdkParameter sdkParam : this.allPathParameters) {
            parameterSpec = sdkParam.generateParameterParameter().build();
            methodBuilder.addParameter(parameterSpec);
            javaDoc.add(PARAM_DOC_NAME_DESCRIPTION, new Object[]{parameterSpec.name, StringUtils.defaultIfEmpty((CharSequence)sdkParam.getDescription(), (CharSequence)sdkParam.getDisplayName())});
        }
        for (SdkParameter sdkParam : this.allQueryParameters) {
            parameterSpec = sdkParam.generateParameterParameter().build();
            methodBuilder.addParameter(parameterSpec);
            javaDoc.add(PARAM_DOC_NAME_DESCRIPTION, new Object[]{parameterSpec.name, StringUtils.defaultIfEmpty((CharSequence)sdkParam.getDescription(), (CharSequence)sdkParam.getDisplayName())});
        }
        for (SdkParameter sdkParam : this.allHeaders) {
            parameterSpec = sdkParam.generateParameterParameter().build();
            methodBuilder.addParameter(parameterSpec);
            javaDoc.add(PARAM_DOC_NAME_DESCRIPTION, new Object[]{parameterSpec.name, StringUtils.defaultIfEmpty((CharSequence)sdkParam.getDescription(), (CharSequence)sdkParam.getDisplayName())});
        }
        this.addContentParameters(javaDoc, methodBuilder);
        ParameterSpec parameterSpec2 = this.generateRequestParametersParameter();
        methodBuilder.addParameter(parameterSpec2);
        javaDoc.add(PARAM_DOC_NAME_DESCRIPTION, new Object[]{parameterSpec2.name, "the {@link " + ((ClassName)parameterSpec2.type).simpleName() + "}"});
        ParameterSpec configurationOverridesParameter = this.generateConfigurationOverridesParameter();
        methodBuilder.addParameter(configurationOverridesParameter);
        javaDoc.add(PARAM_DOC_NAME_DESCRIPTION, new Object[]{configurationOverridesParameter.name, "the {@link ConfigurationOverrides}"});
        ParameterSpec streamingHelperParameter = this.generateStreamingHelperParameter();
        methodBuilder.addParameter(streamingHelperParameter);
        javaDoc.add(PARAM_DOC_NAME_DESCRIPTION, new Object[]{streamingHelperParameter.name, "the {@link StreamingHelper}"});
        if (this.requiresCallbackParameter()) {
            ParameterSpec completionCallbackParameter = this.generateCompletionCallbackParameter();
            methodBuilder.addParameter(completionCallbackParameter);
            javaDoc.add(PARAM_DOC_NAME_DESCRIPTION, new Object[]{completionCallbackParameter.name, "the operation's {@link CompletionCallback}"});
        }
        methodBuilder.addAnnotation(this.generateThrowsAnnotation());
        methodBuilder.addAnnotation(this.generateDisplayNameAnnotation());
        if (StringUtils.isNotBlank((CharSequence)this.operation.getDescription())) {
            methodBuilder.addAnnotation(this.generateDescriptionAnnotation());
        }
        if (this.sampleDataProvider != null) {
            methodBuilder.addAnnotation(this.generateSampleDataAnnotation());
        }
        if (this.requiresMediaTypeAnnotation()) {
            if (this.operation.getOutputMetadata() != null) {
                methodBuilder.addAnnotation(this.generateMediaTypeAnnotation());
            } else {
                methodBuilder.addAnnotation(this.generateDefaultMediaTypeAnnotation());
            }
        }
        if (this.outputMetadataResolver != null && this.outputMetadataResolver.getRequiresMetadataResolver()) {
            methodBuilder.addAnnotation(this.getOutputResolverAnnotation());
        }
        methodBuilder.addCode(this.generateOperationMethodBody());
        methodBuilder.addJavadoc(javaDoc.build());
        TypeName returnType = this.generateMethodReturn();
        if (returnType != null) {
            methodBuilder.returns(returnType);
        }
        return methodBuilder.build();
    }

    private AnnotationSpec getOutputResolverAnnotation() {
        return AnnotationSpec.builder(OutputResolver.class).addMember("output", "$T.class", new Object[]{ClassName.get((String)this.outputMetadataResolver.getPackage(), (String)this.outputMetadataResolver.getClassName(), (String[])new String[0])}).build();
    }

    protected void addContentParameters(CodeBlock.Builder javaDoc, MethodSpec.Builder methodBuilder) {
        if (this.content != null) {
            ParameterSpec parameterSpec = this.content.generateContentParameter();
            methodBuilder.addParameter(parameterSpec);
            javaDoc.add(PARAM_DOC_NAME_DESCRIPTION, new Object[]{parameterSpec.name, "the content to use"});
        }
    }

    private Pagination getPagination() {
        return this.operation.getPagination();
    }

    private boolean isQueryParamDefinedInPagination(String paramName) {
        Pagination pagination = this.getPagination();
        if (pagination != null) {
            return pagination.getPaginationParameter().equalsIgnoreCase(paramName);
        }
        return false;
    }

    private AnnotationSpec generateDisplayNameAnnotation() {
        return AnnotationSpec.builder(DisplayName.class).addMember("value", "$S", new Object[]{this.operation.getDisplayName()}).build();
    }

    public CodeBlock.Builder generateCommonOperationMethodBody() {
        CodeBlock.Builder methodBody = CodeBlock.builder();
        methodBody.addStatement("$T requestPath = $S", new Object[]{String.class, this.operation.getPath()});
        for (SdkParameter pathParam : this.allPathParameters) {
            if (pathParam.isArrayType()) {
                methodBody.addStatement("requestPath = $L.matcher(requestPath).replaceAll($L.stream().map(v -> $L).collect($T.joining(\",\")))", new Object[]{this.getPathParamPatternFieldName(pathParam), pathParam.getJavaName(), pathParam.getStringValueGetter("v"), Collectors.class});
                continue;
            }
            methodBody.addStatement("requestPath = $L.matcher(requestPath).replaceAll($L)", new Object[]{this.getPathParamPatternFieldName(pathParam), pathParam.getStringValueGetter()});
        }
        String baseUriString = "connection.getBaseUri()";
        if (StringUtils.isNotBlank((CharSequence)this.operation.getAlternativeBaseUri()) && this.connectorModel.getBaseUri().isMultipleBaseUri()) {
            String multipleBaseUri = this.connectorModel.getBaseUri().getMultipleBaseUriOrDefault(this.operation.getAlternativeBaseUri());
            baseUriString = "\"" + multipleBaseUri + "\"";
        }
        methodBody.add("$1T builder = new $1T($2L, requestPath, $3T.$4L, parameters)", new Object[]{RestRequestBuilder.class, baseUriString, HttpConstants.Method.class, this.operation.getHttpMethod().toUpperCase()});
        methodBody.add(".setQueryParamFormat($L)", new Object[]{QUERY_PARAM_FORMAT_FIELD});
        if (this.operation.getInputMetadata() != null && this.operation.getInputMetadata().getMediaType() != null) {
            String mediaType = this.operation.getInputMetadata().getMediaType().toString();
            if (this.operation.getInputMetadata().getMediaType().equals((Object)javax.ws.rs.core.MediaType.MULTIPART_FORM_DATA_TYPE)) {
                mediaType = mediaType + "; boundary=__rc2_34b212";
            }
            methodBody.add(".$L($S, $S)", new Object[]{ADD_HEADER_METHOD_NAME, CONTENT_TYPE_HEADER_NAME, mediaType});
        }
        if (this.operation.getOutputMetadata() != null && this.operation.getOutputMetadata().getMediaType() != null) {
            methodBody.add(".$L($S, $S)", new Object[]{ADD_HEADER_METHOD_NAME, ACCEPT_HEADER_NAME, this.operation.getOutputMetadata().getMediaType().toString()});
        }
        for (SdkParameter queryParam : this.allQueryParameters) {
            if (this.isQueryParamDefinedInPagination(queryParam.getExternalName())) continue;
            methodBody.add(this.generateRequestBuilderParameterCodeBlock(queryParam, ADD_QUERY_PARAM_METHOD_NAME, ADD_MULTIPLE_QUERY_PARAM_METHOD_NAME));
        }
        for (SdkParameter header : this.allHeaders) {
            methodBody.add(this.generateRequestBuilderParameterCodeBlock(header, ADD_HEADER_METHOD_NAME, ADD_MULTIPLE_HEADER_METHOD_NAME));
        }
        this.addSetBodyMethod(methodBody);
        methodBody.add(";", new Object[0]);
        return methodBody;
    }

    protected void addSetBodyMethod(CodeBlock.Builder methodBody) {
        if (this.content != null) {
            methodBody.add(".setBody($L, overrides.getStreamingType())", new Object[]{this.content.getContentParameterJavaName()});
        }
    }

    private CodeBlock generateRequestBuilderParameterCodeBlock(SdkParameter parameter, String addSingleValueMethodName, String addMultipleValueMethodName) {
        CodeBlock.Builder builder = CodeBlock.builder();
        String methodName = parameter.isArrayType() ? addMultipleValueMethodName : addSingleValueMethodName;
        builder.add(".$L($S, $L)", new Object[]{methodName, parameter.getExternalName(), this.getParameterValueStatement(parameter)});
        return builder.build();
    }

    private CodeBlock getParameterValueStatement(SdkParameter parameter) {
        CodeBlock.Builder builder = CodeBlock.builder();
        if (parameter.isArrayType()) {
            String getter = parameter.getInnerTypeStringValueGetter("v");
            if (getter.equals("v")) {
                builder.add("$L.stream().filter($T::nonNull).collect($T.toList())", new Object[]{parameter.getJavaName(), Objects.class, Collectors.class});
            } else {
                builder.add("$L.stream().filter($T::nonNull).map(v -> $L).collect($T.toList())", new Object[]{parameter.getJavaName(), Objects.class, getter, Collectors.class});
            }
        } else {
            builder.add("$L", new Object[]{parameter.getStringValueGetter()});
        }
        return builder.build();
    }

    private AnnotationSpec generateThrowsAnnotation() {
        return AnnotationSpec.builder(Throws.class).addMember("value", "$T.class", new Object[]{RequestErrorTypeProvider.class}).build();
    }

    private AnnotationSpec generateMediaTypeAnnotation() {
        return AnnotationSpec.builder(MediaType.class).addMember("value", "$S", new Object[]{this.operation.getOutputMetadata().getMediaType()}).build();
    }

    private AnnotationSpec generateSampleDataAnnotation() {
        return AnnotationSpec.builder(SampleData.class).addMember("value", "$T.class", new Object[]{ClassName.get((String)this.sampleDataProvider.getPackage(), (String)this.sampleDataProvider.getJavaClassName(), (String[])new String[0])}).build();
    }

    private AnnotationSpec generateDefaultMediaTypeAnnotation() {
        return AnnotationSpec.builder(MediaType.class).addMember("value", "$S", new Object[]{this.operationMethodRequiresBody() ? "application/json" : "text/plain"}).build();
    }

    private ParameterSpec generateConfigParameter() {
        return ParameterSpec.builder(RestConfiguration.class, (String)"config", (Modifier[])new Modifier[0]).addAnnotation(Config.class).build();
    }

    private ParameterSpec generateConnectionParameter() {
        return ParameterSpec.builder(RestConnection.class, (String)"connection", (Modifier[])new Modifier[0]).addAnnotation(Connection.class).build();
    }

    private ParameterSpec generateRequestParametersParameter() {
        AnnotationSpec parameterGroupAnnotation = AnnotationSpec.builder(ParameterGroup.class).addMember("name", REQUEST_PARAMETERS_GROUP_NAME, new Object[0]).build();
        Class requestParameterClass = this.operation.getInputMetadata() != null ? EntityRequestParameters.class : NonEntityRequestParameters.class;
        return ParameterSpec.builder(requestParameterClass, (String)"parameters", (Modifier[])new Modifier[0]).addAnnotation(parameterGroupAnnotation).build();
    }

    private ParameterSpec generateConfigurationOverridesParameter() {
        AnnotationSpec parameterGroupAnnotation = AnnotationSpec.builder(ParameterGroup.class).addMember("name", CONNECTOR_OVERRIDES, new Object[0]).build();
        return ParameterSpec.builder(ConfigurationOverrides.class, (String)"overrides", (Modifier[])new Modifier[0]).addAnnotation(parameterGroupAnnotation).build();
    }

    private ParameterSpec generateStreamingHelperParameter() {
        return ParameterSpec.builder(StreamingHelper.class, (String)"streamingHelper", (Modifier[])new Modifier[0]).build();
    }

    private ParameterSpec generateCompletionCallbackParameter() {
        MessageOutputType messageOutputType = this.getMessageOutputType();
        return ParameterSpec.builder((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(CompletionCallback.class), (TypeName[])new TypeName[]{messageOutputType.getOutputType(), messageOutputType.getAttributeOutputType()}), (String)"callback", (Modifier[])new Modifier[0]).build();
    }

    protected MessageOutputType getMessageOutputType() {
        if (!this.isVoidOperation() && (this.outputMetadataResolver != null || this.operationMethodRequiresBody())) {
            return new MessageOutputType(InputStream.class, HttpResponseAttributes.class);
        }
        return new MessageOutputType(String.class, HttpResponseAttributes.class);
    }

    protected boolean operationMethodRequiresBody() {
        return this.operation.getHttpMethod().equalsIgnoreCase("get") || this.operation.getHttpMethod().equalsIgnoreCase("post") || this.operation.getHttpMethod().equalsIgnoreCase("patch") || this.operation.getHttpMethod().equalsIgnoreCase("options");
    }

    protected boolean isVoidOperation() {
        return this.operation.getVoidOperation() != null && this.operation.getVoidOperation() != false;
    }

    protected boolean requiresConnectionParameter() {
        return true;
    }

    protected boolean requiresCallbackParameter() {
        return true;
    }

    protected boolean requiresMediaTypeAnnotation() {
        return true;
    }

    public List<SdkParameter> getAllParameters() {
        LinkedList<SdkParameter> allParameters = new LinkedList<SdkParameter>();
        allParameters.addAll(this.allPathParameters);
        allParameters.addAll(this.allQueryParameters);
        allParameters.addAll(this.allHeaders);
        return allParameters;
    }

    public ConnectorOperation getConnectorOperation() {
        return this.operation;
    }

    public static class MessageOutputType {
        private final TypeName outputType;
        private final TypeName attributeOutputType;

        public MessageOutputType(TypeName outputType, TypeName attributeOutputType) {
            this.outputType = outputType;
            this.attributeOutputType = attributeOutputType;
        }

        public MessageOutputType(Class<?> outputType, Class<?> attributeOutputType) {
            this((TypeName)ClassName.get(outputType), (TypeName)ClassName.get(attributeOutputType));
        }

        public TypeName getOutputType() {
            return this.outputType;
        }

        public TypeName getAttributeOutputType() {
            return this.attributeOutputType;
        }
    }
}

