/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.templating.sdk.operation;

import static com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.PaginationTypeDescriptor.HYPERMEDIA;
import static com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.PaginationTypeDescriptor.MARKER;
import static com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.PaginationTypeDescriptor.OFFSET;
import static com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.PaginationTypeDescriptor.PAGE_NUMBER;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorModel;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorOperation;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.type.MultipartTypeDefinition;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.PaginationTypeDescriptor;
import com.mulesoft.connectivity.rest.sdk.templating.api.RestSdkRunConfiguration;
import com.mulesoft.connectivity.rest.sdk.templating.exception.TemplatingException;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.SdkConnector;

import java.nio.file.Path;

public class SdkOperationFactory {

  public static AbstractSdkOperation create(Path outputDir, ConnectorModel connectorModel, SdkConnector sdkConnector,
                                            ConnectorOperation operation, RestSdkRunConfiguration runConfiguration)
      throws TemplatingException {
    if (operation.hasPagination()) {
      PaginationTypeDescriptor pagingType = operation.getPagination().getType();

      if (pagingType.equals(OFFSET)) {
        return new SdkOffsetPaginationOperation(outputDir, connectorModel, sdkConnector, operation, runConfiguration);
      } else if (pagingType.equals(MARKER)) {
        return new SdkMarkerPaginationOperation(outputDir, connectorModel, sdkConnector, operation, runConfiguration);
      } else if (pagingType.equals(PAGE_NUMBER)) {
        return new SdkPageNumberPaginationOperation(outputDir, connectorModel, sdkConnector, operation, runConfiguration);
      } else if (pagingType.equals(HYPERMEDIA)) {
        return new SdkHypermediaPaginationOperation(outputDir, connectorModel, sdkConnector, operation, runConfiguration);
      }
    }

    if (operation.getInputMetadata() instanceof MultipartTypeDefinition) {
      return new SdkMultipartOperation(outputDir, connectorModel, sdkConnector, operation, runConfiguration);
    }

    return new SdkOperation(outputDir, connectorModel, sdkConnector, operation, runConfiguration);
  }

}
