/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.templating.sdk.metadata;

import com.mulesoft.connectivity.rest.commons.api.datasense.metadata.input.BooleanInputMetadataResolver;
import com.mulesoft.connectivity.rest.commons.api.datasense.metadata.input.DateOnlyInputMetadataResolver;
import com.mulesoft.connectivity.rest.commons.api.datasense.metadata.input.DateTimeInputMetadataResolver;
import com.mulesoft.connectivity.rest.commons.api.datasense.metadata.input.FileInputMetadataResolver;
import com.mulesoft.connectivity.rest.commons.api.datasense.metadata.input.FromJsonInputMetadataResolver;
import com.mulesoft.connectivity.rest.commons.api.datasense.metadata.input.IntegerInputMetadataResolver;
import com.mulesoft.connectivity.rest.commons.api.datasense.metadata.input.JsonInputMetadataResolver;
import com.mulesoft.connectivity.rest.commons.api.datasense.metadata.input.NumberInputMetadataResolver;
import com.mulesoft.connectivity.rest.commons.api.datasense.metadata.input.StringInputMetadataResolver;
import com.mulesoft.connectivity.rest.commons.api.datasense.metadata.input.TimeOnlyInputMetadataResolver;
import com.mulesoft.connectivity.rest.commons.api.datasense.metadata.input.XmlInputMetadataResolver;
import com.mulesoft.connectivity.rest.commons.api.datasense.metadata.input.dynamic.FromJsonInputDynamicMetadataResolver;
import com.mulesoft.connectivity.rest.commons.api.datasense.metadata.input.dynamic.JsonInputDynamicMetadataResolver;
import com.mulesoft.connectivity.rest.commons.api.datasense.metadata.input.dynamic.XmlInputDynamicMetadataResolver;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorModel;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorOperation;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.type.PrimitiveTypeDefinition;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.type.TypeDefinition;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.type.schema.CustomTypeSchema;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.type.schema.JsonTypeSchema;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.type.schema.TypeSchema;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.type.schema.XmlTypeSchema;
import com.mulesoft.connectivity.rest.sdk.templating.api.RestSdkRunConfiguration;
import com.mulesoft.connectivity.rest.sdk.templating.exception.TemplatingException;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.SdkConnector;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.metadata.SdkAbstractStaticMetadataResolver;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.util.FileGenerationUtil;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.util.MediaTypeUtil;
import java.nio.file.Path;

public class SdkInputMetadataResolver
extends SdkAbstractStaticMetadataResolver {
    private String qName;

    public SdkInputMetadataResolver(Path outputDir, ConnectorModel connectorModel, SdkConnector sdkConnector, ConnectorOperation operation, TypeDefinition typeDefinition, FileGenerationUtil.SchemaNameType schemaNameType, String partName, RestSdkRunConfiguration runConfiguration) throws TemplatingException {
        super(outputDir, connectorModel, sdkConnector, operation, typeDefinition, schemaNameType, partName, "", runConfiguration);
    }

    @Override
    protected Class<?> buildSuperclass(TypeDefinition typeDefinition) throws TemplatingException {
        TypeSchema typeSchema = typeDefinition.getTypeSchema();
        if (typeDefinition instanceof PrimitiveTypeDefinition) {
            return this.getPrimitiveMetadataResolverClass((PrimitiveTypeDefinition)typeDefinition);
        }
        if (typeSchema instanceof XmlTypeSchema) {
            this.qName = ((XmlTypeSchema)typeDefinition.getTypeSchema()).getElementName();
            return this.runConfiguration.useDynamicTypeResolvers() ? XmlInputDynamicMetadataResolver.class : XmlInputMetadataResolver.class;
        }
        if (typeSchema instanceof JsonTypeSchema || MediaTypeUtil.isJsonCompatibleMediaType(typeDefinition)) {
            return this.runConfiguration.useDynamicTypeResolvers() ? JsonInputDynamicMetadataResolver.class : JsonInputMetadataResolver.class;
        }
        if (typeSchema instanceof CustomTypeSchema) {
            return this.runConfiguration.useDynamicTypeResolvers() ? FromJsonInputDynamicMetadataResolver.class : FromJsonInputMetadataResolver.class;
        }
        return StringInputMetadataResolver.class;
    }

    protected Class<?> getPrimitiveMetadataResolverClass(PrimitiveTypeDefinition primitiveTypeDefinition) throws TemplatingException {
        PrimitiveTypeDefinition.PrimitiveType primitiveType = primitiveTypeDefinition.getPrimitiveType();
        if (primitiveType.equals((Object)PrimitiveTypeDefinition.PrimitiveType.NUMBER)) {
            return NumberInputMetadataResolver.class;
        }
        if (primitiveType.equals((Object)PrimitiveTypeDefinition.PrimitiveType.INTEGER)) {
            return IntegerInputMetadataResolver.class;
        }
        if (primitiveType.equals((Object)PrimitiveTypeDefinition.PrimitiveType.STRING)) {
            return StringInputMetadataResolver.class;
        }
        if (primitiveType.equals((Object)PrimitiveTypeDefinition.PrimitiveType.BOOLEAN)) {
            return BooleanInputMetadataResolver.class;
        }
        if (primitiveType.equals((Object)PrimitiveTypeDefinition.PrimitiveType.DATE_TIME) || primitiveType.equals((Object)PrimitiveTypeDefinition.PrimitiveType.DATE_TIME_ONLY) || primitiveType.equals((Object)PrimitiveTypeDefinition.PrimitiveType.ZONED_DATE_TIME) || primitiveType.equals((Object)PrimitiveTypeDefinition.PrimitiveType.LOCAL_DATE_TIME)) {
            return DateTimeInputMetadataResolver.class;
        }
        if (primitiveType.equals((Object)PrimitiveTypeDefinition.PrimitiveType.TIME_ONLY)) {
            return TimeOnlyInputMetadataResolver.class;
        }
        if (primitiveType.equals((Object)PrimitiveTypeDefinition.PrimitiveType.DATE_ONLY) || primitiveType.equals((Object)PrimitiveTypeDefinition.PrimitiveType.DATE)) {
            return DateOnlyInputMetadataResolver.class;
        }
        if (primitiveType.equals((Object)PrimitiveTypeDefinition.PrimitiveType.FILE)) {
            return FileInputMetadataResolver.class;
        }
        throw new TemplatingException("Primitive type not supported: " + primitiveType.name());
    }

    @Override
    protected String getClassNameSuffix() {
        return "InputMetadataResolver";
    }

    @Override
    protected boolean requiresQNameMethod() {
        return this.superclass.equals(XmlInputMetadataResolver.class) || this.superclass.equals(XmlInputDynamicMetadataResolver.class);
    }

    @Override
    protected boolean requiresFormatMethod() {
        return this.superclass.equals(FromJsonInputMetadataResolver.class) || this.superclass.equals(FileInputMetadataResolver.class) || this.superclass.equals(FromJsonInputDynamicMetadataResolver.class);
    }

    @Override
    protected String getQName() {
        return this.qName;
    }

    @Override
    protected boolean requiresToWriteSchema() {
        return this.superclass.equals(FromJsonInputMetadataResolver.class) || this.superclass.equals(JsonInputMetadataResolver.class) || this.superclass.equals(XmlInputMetadataResolver.class) || this.superclass.equals(FromJsonInputDynamicMetadataResolver.class) || this.superclass.equals(JsonInputDynamicMetadataResolver.class) || this.superclass.equals(XmlInputDynamicMetadataResolver.class);
    }
}

