/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.templating.sdk.util;

import com.google.common.base.Charsets;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorOperation;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.type.schema.CustomTypeSchema;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.type.schema.JsonTypeSchema;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.type.schema.TypeSchema;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.type.schema.XmlTypeSchema;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.util.XmlUtils;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Path;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONObject;

public class FileGenerationUtil {
    public static void writeSchema(TypeSchema source, Path outputDir, String schemaName) {
        try {
            File file = outputDir.resolve(schemaName).toFile();
            if (file.exists()) {
                return;
            }
            String schemaString = source.getRawSchema();
            if (source instanceof JsonTypeSchema) {
                JSONObject jObject = new JSONObject(schemaString);
                schemaString = jObject.toString(2);
            }
            FileUtils.writeStringToFile((File)file, (String)schemaString, (Charset)Charsets.UTF_8);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(String.format("Path %s is invalid.", outputDir), e);
        }
    }

    public static String generateSchemaName(TypeSchema source, ConnectorOperation operation, SchemaNameType nameType, String partName) {
        String suffix = FileGenerationUtil.getSchemaSuffix(source, nameType, partName);
        return operation.getInternalName() + suffix;
    }

    private static String getSchemaSuffix(TypeSchema source, SchemaNameType nameType, String partName) {
        String schemaSuffix = "";
        switch (nameType) {
            case INPUT: {
                schemaSuffix = "-input-schema.";
                break;
            }
            case OUTPUT: {
                schemaSuffix = "-output-schema.";
                break;
            }
            case PART: {
                schemaSuffix = "-part-input-schema.";
            }
        }
        if (StringUtils.isNotBlank((CharSequence)partName)) {
            schemaSuffix = "-" + XmlUtils.getXmlName((String)partName) + schemaSuffix;
        }
        return schemaSuffix + FileGenerationUtil.getExtension(source);
    }

    private static String getExtension(TypeSchema source) {
        if (source instanceof XmlTypeSchema) {
            return "xsd";
        }
        if (source instanceof JsonTypeSchema || source instanceof CustomTypeSchema) {
            return "json";
        }
        throw new IllegalArgumentException("Type Schema class doesn't support typeSchema generation.");
    }

    public static boolean supportsSchemaGeneration(TypeSchema source) {
        return source instanceof XmlTypeSchema || source instanceof JsonTypeSchema || source instanceof CustomTypeSchema;
    }

    public static enum SchemaNameType {
        INPUT,
        OUTPUT,
        PART;

    }
}

