/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.templating.sdk.configuration.layers;

import com.mulesoft.connectivity.rest.commons.api.error.RestError;
import com.mulesoft.connectivity.rest.commons.api.interception.descriptor.HttpResponseInterceptorDescriptor;
import com.mulesoft.connectivity.rest.commons.api.interception.descriptor.builder.HttpResponseInterceptorDescriptorBuilder;
import com.mulesoft.connectivity.rest.commons.api.interception.descriptor.builder.PreconditionHttpResponseInterceptorDelegateDescriptorBuilder;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorInterceptor;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorModel;
import com.mulesoft.connectivity.rest.sdk.templating.api.RestSdkRunConfiguration;
import com.mulesoft.connectivity.rest.sdk.templating.exception.TemplatingException;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.SdkConnector;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.configuration.layers.AbstractSdkConfigLayer;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.nio.file.Path;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.lang.model.element.Modifier;

public class SdkConfigBaseLayer
extends AbstractSdkConfigLayer {
    private static final String GET_RESPONSE_INTERCEPTOR_DESCRIPTOR = "getResponseInterceptorDescriptor";
    private final TypeName superclass;

    public SdkConfigBaseLayer(Path outputDir, ConnectorModel connectorModel, SdkConnector sdkConnector, String javaClassName, String packageName, TypeName superclass, RestSdkRunConfiguration runConfiguration) {
        super(outputDir, connectorModel, sdkConnector, javaClassName, packageName, runConfiguration);
        this.superclass = superclass;
    }

    @Override
    public String getJavaClassName() {
        return super.getJavaClassName() + "Base";
    }

    @Override
    public String getPackage() {
        return super.getPackage() + ".base";
    }

    @Override
    public void applyTemplates() throws TemplatingException {
        this.generateConfigClass();
    }

    private void generateConfigClass() throws TemplatingException {
        TypeSpec.Builder configClassBuilder = TypeSpec.classBuilder((String)this.getJavaClassName()).addModifiers(new Modifier[]{Modifier.PUBLIC}).addModifiers(new Modifier[]{Modifier.ABSTRACT}).superclass(this.superclass);
        if (this.connectorModel.getInterceptors() != null && this.connectorModel.getInterceptors().size() > 0) {
            this.addResponseInterceptorDescriptor(configClassBuilder);
        }
        JavaFile.Builder javaFileBuilder = this.getJavaFileBuilderForClass(configClassBuilder.build(), this.getPackage());
        this.writeJavaFile(javaFileBuilder.build());
    }

    private CodeBlock generateInterceptorDescriptor() {
        CodeBlock.Builder methodBody = CodeBlock.builder();
        methodBody.addStatement("$1T.Matcher isRestSdkErrorPrecondition = statusCode -> $2T.getErrorByCode(statusCode).isPresent()", new Object[]{PreconditionHttpResponseInterceptorDelegateDescriptorBuilder.class, RestError.class});
        methodBody.addStatement("$1T.Matcher isRestSdkNotErrorPrecondition = statusCode -> !$2T.getErrorByCode(statusCode).isPresent()", new Object[]{PreconditionHttpResponseInterceptorDelegateDescriptorBuilder.class, RestError.class});
        methodBody.addStatement("$1T httpResponseInterceptorDescriptorBuilder = $2T.builder()", new Object[]{HttpResponseInterceptorDescriptorBuilder.class, HttpResponseInterceptorDescriptor.class});
        List<ConnectorInterceptor> interceptorsOnError = this.connectorModel.getInterceptors().stream().filter(x -> x.isOnError()).collect(Collectors.toList());
        List<ConnectorInterceptor> interceptorsOnSuccess = this.connectorModel.getInterceptors().stream().filter(x -> !x.isOnError()).collect(Collectors.toList());
        if (interceptorsOnError != null && interceptorsOnError.size() > 0) {
            this.generateInterceptorDescriptorBlocks(methodBody, interceptorsOnError, "onErrorInterceptorDescriptorConfigurator");
            methodBody.addStatement("httpResponseInterceptorDescriptorBuilder.when(isRestSdkErrorPrecondition, onErrorInterceptorDescriptorConfigurator)", new Object[0]);
        }
        if (interceptorsOnSuccess != null && interceptorsOnSuccess.size() > 0) {
            this.generateInterceptorDescriptorBlocks(methodBody, interceptorsOnSuccess, "onSuccessInterceptorDescriptorConfigurator");
            methodBody.addStatement("httpResponseInterceptorDescriptorBuilder.when(isRestSdkNotErrorPrecondition, onSuccessInterceptorDescriptorConfigurator)", new Object[0]);
        }
        methodBody.addStatement("return httpResponseInterceptorDescriptorBuilder.build()", new Object[0]);
        return methodBody.build();
    }

    private void generateInterceptorDescriptorBlocks(CodeBlock.Builder methodBody, List<ConnectorInterceptor> interceptors, String variableConfiguratorName) {
        methodBody.add("$1T<$2T> " + variableConfiguratorName + " = b -> b", new Object[]{Consumer.class, PreconditionHttpResponseInterceptorDelegateDescriptorBuilder.class});
        for (ConnectorInterceptor connectorInterceptor : interceptors) {
            methodBody.add(".expression(e -> e", new Object[0]);
            if (connectorInterceptor.getExpression() != null) {
                methodBody.add(".matchExpression(\"" + connectorInterceptor.getExpression() + "\")\n", new Object[0]);
            }
            if (connectorInterceptor.getReasonPhrase() != null) {
                methodBody.add(".reasonPhraseExpression(\"" + connectorInterceptor.getReasonPhrase() + "\")\n", new Object[0]);
            }
            if (connectorInterceptor.getStatusCode() != null) {
                methodBody.add(".statusCodeExpression(\"" + connectorInterceptor.getStatusCode() + "\")\n", new Object[0]);
            }
            if (connectorInterceptor.getBody() != null) {
                methodBody.add(".bodyExpression(\"" + connectorInterceptor.getBody() + "\")\n", new Object[0]);
            }
            if (connectorInterceptor.getHeaders() != null) {
                methodBody.add(".headersExpression(\"" + connectorInterceptor.getHeaders() + "\")\n", new Object[0]);
            }
            methodBody.add(")\n", new Object[0]);
        }
        methodBody.add(";", new Object[0]);
    }

    private void addResponseInterceptorDescriptor(TypeSpec.Builder configClassBuilder) {
        MethodSpec getInterceptors = MethodSpec.methodBuilder((String)GET_RESPONSE_INTERCEPTOR_DESCRIPTOR).returns(TypeName.get(HttpResponseInterceptorDescriptor.class)).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).addCode(this.generateInterceptorDescriptor()).build();
        configClassBuilder.addMethod(getInterceptors);
    }
}

