/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.templating.sdk.configuration.layers;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorModel;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.operation.ConnectorOperation;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.security.ConnectorSecurityScheme;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.security.CustomAuthenticationScheme;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.security.MockedAuthenticationScheme;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.trigger.Trigger;
import com.mulesoft.connectivity.rest.sdk.templating.JavaTemplateEntity;
import com.mulesoft.connectivity.rest.sdk.templating.api.RestSdkRunConfiguration;
import com.mulesoft.connectivity.rest.sdk.templating.exception.TemplatingException;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.SdkConnector;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.configuration.layers.AbstractSdkConfigLayer;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.connection.AbstractSdkConnectionProvider;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.connection.SdkConnectionProvider;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.connection.SdkCustomConnectionProvider;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.connection.SdkMockedConnectionProvider;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.model.SdkHttpProxyConfig;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.operation.AbstractSdkOperation;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.operation.SdkOperationFactory;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.trigger.SdkNativeTrigger;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.trigger.SdkTrigger;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.trigger.SdkTriggerTemplate;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.lang.model.element.Modifier;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.extension.api.annotation.Configuration;
import org.mule.runtime.extension.api.annotation.Operations;
import org.mule.runtime.extension.api.annotation.Sources;
import org.mule.runtime.extension.api.annotation.connectivity.ConnectionProviders;

public class SdkConfigImplementationLayer
extends AbstractSdkConfigLayer {
    private final SdkHttpProxyConfig httpProxyConfig;
    private final List<AbstractSdkConnectionProvider> connectionProviders;
    private final List<AbstractSdkOperation> operations;
    private final List<SdkTriggerTemplate> triggers;
    private final TypeName superclass;

    public SdkConfigImplementationLayer(Path outputDir, ConnectorModel connectorModel, SdkConnector sdkConnector, String javaClassName, String packageName, TypeName superclass, RestSdkRunConfiguration runConfiguration) throws TemplatingException {
        super(outputDir, connectorModel, sdkConnector, javaClassName, packageName, runConfiguration);
        this.superclass = superclass;
        this.httpProxyConfig = new SdkHttpProxyConfig(outputDir, connectorModel, runConfiguration);
        this.connectionProviders = this.buildConnectionProviders(outputDir, connectorModel, sdkConnector);
        this.operations = new ArrayList<AbstractSdkOperation>();
        for (ConnectorOperation operation : connectorModel.getOperations()) {
            this.operations.add(SdkOperationFactory.create(outputDir, connectorModel, sdkConnector, operation, runConfiguration));
        }
        this.triggers = new ArrayList<SdkTriggerTemplate>();
        for (Trigger triggerModel : connectorModel.getTriggers()) {
            JavaTemplateEntity trigger = StringUtils.isNotBlank((CharSequence)triggerModel.getFqn()) ? new SdkNativeTrigger(outputDir, connectorModel, triggerModel, runConfiguration) : new SdkTrigger(outputDir, connectorModel, sdkConnector, triggerModel, runConfiguration);
            this.triggers.add((SdkTriggerTemplate)((Object)trigger));
        }
    }

    private List<AbstractSdkConnectionProvider> buildConnectionProviders(Path outputDir, ConnectorModel connectorModel, SdkConnector sdkConnector) throws TemplatingException {
        List securitySchemeModels = connectorModel.getOperations().stream().map(ConnectorOperation::getSecuritySchemes).flatMap(Collection::stream).distinct().collect(Collectors.toList());
        connectorModel.getTriggers().stream().map(Trigger::getOperation).filter(Objects::nonNull).map(ConnectorOperation::getSecuritySchemes).flatMap(Collection::stream).filter(securityScheme -> !securitySchemeModels.contains(securityScheme)).distinct().forEach(securitySchemeModels::add);
        ArrayList<AbstractSdkConnectionProvider> list = new ArrayList<AbstractSdkConnectionProvider>();
        for (ConnectorSecurityScheme scheme : securitySchemeModels) {
            if (scheme.getSchemeType().equals((Object)ConnectorSecurityScheme.SecuritySchemeType.CUSTOM_AUTHENTICATION)) {
                if (!((CustomAuthenticationScheme)scheme).getFqn().isPresent()) continue;
                list.add(new SdkCustomConnectionProvider(outputDir, connectorModel, (CustomAuthenticationScheme)scheme, this.runConfiguration));
                continue;
            }
            if (scheme.getSchemeType().equals((Object)ConnectorSecurityScheme.SecuritySchemeType.MOCKED)) {
                list.add(new SdkMockedConnectionProvider(outputDir, connectorModel, (MockedAuthenticationScheme)scheme, this.runConfiguration));
                continue;
            }
            list.add(new SdkConnectionProvider(outputDir, connectorModel, sdkConnector, scheme, this.httpProxyConfig, this.runConfiguration));
        }
        return list;
    }

    @Override
    public void applyTemplates() throws TemplatingException {
        this.generateConfigClass();
        if (!this.connectionProviders.isEmpty()) {
            this.httpProxyConfig.applyTemplates();
        }
        for (AbstractSdkConnectionProvider connectionProvider : this.connectionProviders) {
            connectionProvider.applyTemplates();
        }
        for (AbstractSdkOperation operation : this.operations) {
            operation.applyTemplates();
        }
        for (SdkTriggerTemplate trigger : this.triggers) {
            trigger.applyTemplates();
        }
    }

    private void generateConfigClass() throws TemplatingException {
        TypeSpec.Builder configClassBuilder = TypeSpec.classBuilder((String)this.getJavaClassName()).addModifiers(new Modifier[]{Modifier.PUBLIC}).superclass(this.superclass).addAnnotation(this.getConfigurationAnnotation()).addAnnotation(this.getOperationsAnnotation()).addAnnotation(this.getConnectionProvidersAnnotation());
        if (!this.triggers.isEmpty()) {
            configClassBuilder.addAnnotation(this.getSourcesAnnotation());
        }
        this.writeClassToFile(configClassBuilder.build(), this.getPackage());
    }

    private AnnotationSpec getSourcesAnnotation() {
        CodeBlock.Builder codeBlock = CodeBlock.builder();
        codeBlock.add("{", new Object[0]);
        for (int i = 0; i < this.triggers.size(); ++i) {
            SdkTriggerTemplate trigger = this.triggers.get(i);
            codeBlock.add("$T.class", new Object[]{trigger.getTypeNameForConfig()});
            if (i >= this.triggers.size() - 1) continue;
            codeBlock.add(",", new Object[0]);
        }
        codeBlock.add("}", new Object[0]);
        AnnotationSpec.Builder sourcesAnnotationBuilder = AnnotationSpec.builder(Sources.class).addMember("value", codeBlock.build());
        return sourcesAnnotationBuilder.build();
    }

    private AnnotationSpec getOperationsAnnotation() {
        CodeBlock.Builder codeBlock = CodeBlock.builder();
        codeBlock.add("{", new Object[0]);
        for (int i = 0; i < this.operations.size(); ++i) {
            AbstractSdkOperation operation = this.operations.get(i);
            if (operation.getOperation().isPrivateOperation().booleanValue()) continue;
            codeBlock.add("$T.class", new Object[]{ClassName.get((String)operation.getPackage(), (String)operation.getJavaClassName(), (String[])new String[0])});
            if (i >= this.operations.size() - 1) continue;
            codeBlock.add(",", new Object[0]);
        }
        codeBlock.add("}", new Object[0]);
        AnnotationSpec.Builder operationsAnnotationBuilder = AnnotationSpec.builder(Operations.class).addMember("value", codeBlock.build());
        return operationsAnnotationBuilder.build();
    }

    private AnnotationSpec getConnectionProvidersAnnotation() {
        CodeBlock.Builder codeBlock = CodeBlock.builder();
        codeBlock.add("{", new Object[0]);
        for (int i = 0; i < this.connectionProviders.size(); ++i) {
            AbstractSdkConnectionProvider connectionProvider = this.connectionProviders.get(i);
            codeBlock.add("$T.class", new Object[]{connectionProvider.getTypeNameForConfig()});
            if (i >= this.connectionProviders.size() - 1) continue;
            codeBlock.add(",", new Object[0]);
        }
        codeBlock.add("}", new Object[0]);
        AnnotationSpec.Builder connectionProvidersAnnotationBuilder = AnnotationSpec.builder(ConnectionProviders.class).addMember("value", codeBlock.build());
        return connectionProvidersAnnotationBuilder.build();
    }

    private AnnotationSpec getConfigurationAnnotation() {
        AnnotationSpec.Builder extensionAnnotationBuilder = AnnotationSpec.builder(Configuration.class);
        return extensionAnnotationBuilder.build();
    }

    public List<AbstractSdkOperation> getOperations() {
        return this.operations;
    }
}

