/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.templating.sdk.connection.authentication;

import com.google.common.base.CaseFormat;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter.SecurityDefaultParameter;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.security.ConnectorSecurityScheme;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.connection.authentication.SdkAuthenticationStrategy;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.util.SdkTemplatingUtils;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeSpec;
import javax.lang.model.element.Modifier;
import org.apache.commons.lang3.ObjectUtils;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.sdk.api.annotation.semantics.security.Password;
import org.mule.sdk.api.annotation.semantics.security.Username;

public abstract class SdkUserPasswordAuthenticationStrategy
extends SdkAuthenticationStrategy {
    public static final String USERNAME_FIELD = "username";
    public static final String PASSWORD_FIELD = "password";
    public static final String USERNAME_FIELD_DEFAULT_DISPLAY_NAME = "Username";
    public static final String USERNAME_FIELD_DEFAULT_SUMMARY = "The username used to authenticate the requests.";
    public static final String PASSWORD_FIELD_DEFAULT_DISPLAY_NAME = "Password";
    public static final String PASSWORD_FIELD_DEFAULT_SUMMARY = "The password used to authenticate the requests.";

    protected SdkUserPasswordAuthenticationStrategy(ConnectorSecurityScheme securityScheme) {
        super(securityScheme);
    }

    protected abstract SecurityDefaultParameter getUsernameDefaultParameter();

    protected abstract SecurityDefaultParameter getPasswordDefaultParameter();

    protected void addUsernameParameterField(TypeSpec.Builder classBuilder) {
        String displayName = USERNAME_FIELD_DEFAULT_DISPLAY_NAME;
        String summary = USERNAME_FIELD_DEFAULT_SUMMARY;
        SecurityDefaultParameter usernameDefaultParameter = this.getUsernameDefaultParameter();
        if (usernameDefaultParameter != null) {
            displayName = (String)ObjectUtils.defaultIfNull((Object)usernameDefaultParameter.getDisplayName(), (Object)displayName);
            summary = (String)ObjectUtils.defaultIfNull((Object)usernameDefaultParameter.getDescription(), (Object)summary);
        }
        FieldSpec fieldSpec = FieldSpec.builder(String.class, (String)USERNAME_FIELD, (Modifier[])new Modifier[]{Modifier.PROTECTED}).addAnnotation(Parameter.class).addAnnotation(Username.class).addAnnotation(SdkTemplatingUtils.getDisplayNameAnnotation(displayName)).addAnnotation(SdkTemplatingUtils.getSummaryAnnotation(summary)).build();
        MethodSpec getter = SdkTemplatingUtils.generateGetter(fieldSpec, CaseFormat.LOWER_CAMEL, Modifier.PROTECTED).addAnnotation(Override.class).build();
        classBuilder.addField(fieldSpec).addMethod(getter);
    }

    protected void addPasswordParameterField(TypeSpec.Builder classBuilder) {
        String displayName = PASSWORD_FIELD_DEFAULT_DISPLAY_NAME;
        String summary = PASSWORD_FIELD_DEFAULT_SUMMARY;
        SecurityDefaultParameter passwordDefaultParameter = this.getPasswordDefaultParameter();
        if (passwordDefaultParameter != null) {
            displayName = (String)ObjectUtils.defaultIfNull((Object)passwordDefaultParameter.getDisplayName(), (Object)displayName);
            summary = (String)ObjectUtils.defaultIfNull((Object)passwordDefaultParameter.getDescription(), (Object)summary);
        }
        FieldSpec fieldSpec = FieldSpec.builder(String.class, (String)PASSWORD_FIELD, (Modifier[])new Modifier[]{Modifier.PROTECTED}).addAnnotation(Parameter.class).addAnnotation(Password.class).addAnnotation(Optional.class).addAnnotation(SdkTemplatingUtils.getDisplayNameAnnotation(displayName)).addAnnotation(SdkTemplatingUtils.getSummaryAnnotation(summary)).build();
        MethodSpec getter = SdkTemplatingUtils.generateGetter(fieldSpec, CaseFormat.LOWER_CAMEL, Modifier.PROTECTED).addAnnotation(Override.class).build();
        classBuilder.addField(fieldSpec).addMethod(getter);
    }

    @Override
    public void addDefaultClassMembers(TypeSpec.Builder connectionProviderClassBuilder) {
        this.addUsernameParameterField(connectionProviderClassBuilder);
        this.addPasswordParameterField(connectionProviderClassBuilder);
    }
}

