/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.templating.sdk.operation;

import com.mulesoft.connectivity.rest.commons.api.binding.ParameterBinding;
import com.mulesoft.connectivity.rest.commons.api.connection.RestConnection;
import com.mulesoft.connectivity.rest.commons.internal.util.RestRequestBuilder;
import com.mulesoft.connectivity.rest.commons.internal.util.StreamUtils;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorModel;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.operation.ConnectorOperation;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.pagination.Pagination;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter.Parameter;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.type.ArrayTypeDefinition;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.type.TypeDefinition;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.util.JavaUtils;
import com.mulesoft.connectivity.rest.sdk.templating.api.RestSdkRunConfiguration;
import com.mulesoft.connectivity.rest.sdk.templating.exception.TemplatingException;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.SdkConnector;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.operation.AbstractSdkOperation;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.operation.SdkPaginationStrategy;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.parameter.SdkParameter;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.util.TypeDefinitionUtil;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.lang.reflect.Type;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.lang.model.element.Modifier;
import org.apache.commons.lang3.tuple.Pair;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.util.Reference;
import org.mule.runtime.extension.api.annotation.Ignore;
import org.mule.runtime.extension.api.runtime.streaming.PagingProvider;
import org.mule.runtime.http.api.HttpConstants;

public abstract class AbstractSdkPaginationOperation
extends AbstractSdkOperation
implements SdkPaginationStrategy {
    private final Pagination pagination;
    private static final String BASE_REQUEST_BUILDER_MAIN_METHOD_NAME = "RequestBuilderMain";
    private static final String BASE_PAGING_PROVIDER_MAIN_METHOD_NAME = "PagingProviderMain";
    private static final String PARAMETER_REQUEST_FACTORY = "requestFactory";
    protected static final String DEFAULT_PAGING_PARAMETER = "defaultPagingParameter";
    private static final String PARAMETERS_BINDINGS_REF_NAME = "parameterBindingsRef";
    private static final String CUSTOM_PARAMETERS_BINDINGS_REF_NAME = "customParameterBindingsRef";
    private static final String INITIALISE_QUERY_PARAMS = "initMappedQueryParams";
    private static final String INITIALISE_URI_PARAMS = "initMappedUriParams";
    private static final String INITIALISE_HEADER_PARAMS = "initMappedHeaderParams";
    private static final String DEFAULT_QUERY_PARAM_NAME_CONVENTION = "DefaultQueryParam";
    private static final String DEFAULT_URI_PARAM_NAME_CONVENTION = "DefaultUriParam";
    private static final String DEFAULT_HEADER_PARAM_NAME_CONVENTION = "DefaultHeaderParam";
    private static final String ADD_URI_PARAMS_METHOD_NAME = "addUriParams";
    private static final String ADD_QUERY_PARAMS_METHOD_NAME = "addQueryParams";
    private static final String ADD_HEADER_PARAMS_METHOD_NAME = "addHeaderParams";
    private static final String FILTER_PARAMETERS_BOUND_METHOD = "filterParametersAlreadyBound";
    private static final String QUERY_PARAMS_REQUEST_BINDING = "queryParamsRequestBinding";
    private static final String URI_PARAMS_REQUEST_BINDING = "uriParamsRequestBinding";
    private static final String HEADER_PARAMS_REQUEST_BINDING = "headerParamsRequestBinding";

    public AbstractSdkPaginationOperation(Path outputDir, ConnectorModel connectorModel, SdkConnector sdkConnector, ConnectorOperation operation, RestSdkRunConfiguration runConfiguration) throws TemplatingException {
        super(outputDir, connectorModel, sdkConnector, operation, runConfiguration);
        this.pagination = operation.getPagination();
    }

    public Pagination getPagination() {
        return this.pagination;
    }

    @Override
    protected void generateOperationMethodsFlow(TypeSpec.Builder operationClassBuilder) throws TemplatingException {
        operationClassBuilder.addMethod(this.generateBaseMainMethod());
        operationClassBuilder.addMethod(this.generateRequestBuilderMainMethod());
        operationClassBuilder.addMethod(this.generatePagingProviderMainMethod());
        operationClassBuilder.addMethod(this.getExternalPagingProvider());
    }

    protected MethodSpec getExternalPagingProvider() throws TemplatingException {
        MethodSpec.Builder methodSpecBuilder = MethodSpec.methodBuilder((String)("get" + JavaUtils.getJavaUpperCamelNameFromXml((String)this.operation.getInternalName()) + "ExternalPagingProvider"));
        methodSpecBuilder.addModifiers(new Modifier[]{Modifier.PUBLIC});
        methodSpecBuilder.addAnnotation(Ignore.class);
        methodSpecBuilder.addParameters((Iterable)this.generateExternalPagingProviderMethodParameters().parametersSpecList().getLeft());
        methodSpecBuilder.addCode(this.generateExternalPagingProviderMethodBaseMainBody());
        TypeName returnType = this.generateMethodReturn();
        if (returnType != null) {
            methodSpecBuilder.returns(returnType);
        }
        return methodSpecBuilder.build();
    }

    protected void addResponseBindings(CodeBlock.Builder block) {
        if (this.operation.getResponseBindings() != null && !((List)this.operation.getResponseBindings().get()).isEmpty()) {
            block.add(".withResponseBinding(getResponseBindings())", new Object[0]);
        }
        block.add(";", new Object[0]);
    }

    @Override
    public CodeBlock getPagingMethodOperation() throws TemplatingException {
        CodeBlock.Builder block = CodeBlock.builder();
        block.add("return new $T($S, $L, $L, $L, $S,  resolveDefaultResponseMediaType(config), $L, $L, overrides.getResponseTimeoutAsMillis())", new Object[]{this.getPagingProviderClass(), this.pagination.getPaginationParameter(), DEFAULT_PAGING_PARAMETER, PARAMETER_REQUEST_FACTORY, "expressionLanguage", this.getPayloadExpression(), "parameterBindings", "customParameterBindings"});
        this.addResponseBindings(block);
        return block.build();
    }

    protected SdkParameter getPagingParameter() throws TemplatingException {
        return this.allQueryParameters.stream().filter(x -> x.getExternalName().equalsIgnoreCase(this.pagination.getPaginationParameter())).findFirst().orElseThrow(() -> new TemplatingException("Could not get paging parameter, this is a bug."));
    }

    @Override
    public TypeName generateMethodReturn() {
        return ParameterizedTypeName.get((ClassName)ClassName.get(PagingProvider.class), (TypeName[])new TypeName[]{TypeName.get(RestConnection.class), ParameterizedTypeName.get(TypedValue.class, (Type[])new Type[]{String.class})});
    }

    @Override
    protected AbstractSdkOperation.MessageOutputType getMessageOutputType() {
        ParameterizedTypeName parameterizedTypeName = ParameterizedTypeName.get(List.class, (Type[])new Type[]{String.class});
        TypeName attribute = TypeName.get(Void.class);
        return new AbstractSdkOperation.MessageOutputType((TypeName)parameterizedTypeName, attribute);
    }

    @Override
    protected AbstractSdkOperation.ParametersBuilder generateBaseMainMethodParameters() {
        return AbstractSdkOperation.builder().configurationParameter().uriParametersMap().queryParametersMap().headerParametersMap().parameterBinding().customParameterBinding().requestBindingParameter().contentParameter(this.generateContentParameters(false)).requestParameter().configurationOverridesParameter().expressionLanguageParameter();
    }

    @Override
    protected Pair<List<ParameterSpec>, CodeBlock.Builder> generateOperationImplementationMethodParameters() {
        return AbstractSdkOperation.builder().withAnnotations().configurationParameter().uriParameters(this.allUriParameters).queryParameters(this.generateQueryParameters()).headerParameters(this.allHeaders).auxParameters(this.auxParameters).contentParameter(this.generateContentParameters(true)).requestParameter().configurationOverridesParameter().parametersSpecList();
    }

    @Override
    public CodeBlock generateOperationMethodBaseMainBody() throws TemplatingException {
        CodeBlock.Builder paginationBody = CodeBlock.builder();
        paginationBody.add(this.toCursorProviderVariables());
        paginationBody.addStatement("$T<$T,$T> $L = connection -> $L", new Object[]{Function.class, RestConnection.class, RestRequestBuilder.class, PARAMETER_REQUEST_FACTORY, this.generateRequestBuilderMainCall()});
        paginationBody.add(this.generatePagingProviderCall());
        return paginationBody.build();
    }

    private CodeBlock toCursorProviderVariables() {
        CodeBlock.Builder builder = CodeBlock.builder();
        builder.addStatement("$1T<$2T> $3L = new $1T<>($4T.resolveCursorProvider($5L))", new Object[]{Reference.class, Map.class, PARAMETERS_BINDINGS_REF_NAME, StreamUtils.class, "parameterBindings"});
        builder.addStatement("$1T<$2T> $3L = new $1T<>($4T.resolveCursorProvider($5L))", new Object[]{Reference.class, Map.class, CUSTOM_PARAMETERS_BINDINGS_REF_NAME, StreamUtils.class, "customParameterBindings"});
        return builder.build();
    }

    protected abstract boolean externalizePagingParam();

    @Override
    public CodeBlock generateOperationMainCall(TypeName returnType) {
        CodeBlock.Builder builder = CodeBlock.builder();
        List<String> params = this.generateOperationMainCallParameters();
        builder.add(this.generateAuxParameterBindings());
        builder.addStatement("$T<$T, $T> $L = new $T<>()", new Object[]{Map.class, String.class, Object.class, "queryParams", HashMap.class});
        for (SdkParameter parameter : this.allQueryParameters.stream().filter(sdkParameter -> !this.isQueryParamDefinedInPagination(sdkParameter.getExternalName())).collect(Collectors.toList())) {
            builder.addStatement("$L.put(\"" + parameter.getExternalName() + "\"," + this.getParameterValueStatement(parameter) + ")", new Object[]{"queryParams"});
        }
        builder.addStatement("$T<$T, $T> $L = new $T<>()", new Object[]{Map.class, String.class, Object.class, "uriParams", HashMap.class});
        for (SdkParameter parameter : this.allUriParameters) {
            builder.addStatement("$L.put(\"" + parameter.getExternalName() + "\"," + this.getParameterValueStatement(parameter) + ")", new Object[]{"uriParams"});
        }
        builder.addStatement("$T<$T, $T> $L = new $T<>()", new Object[]{Map.class, String.class, Object.class, "headerParams", HashMap.class});
        for (SdkParameter parameter : this.allHeaders) {
            builder.addStatement("$L.put(\"" + parameter.getExternalName() + "\"," + this.getParameterValueStatement(parameter) + ")", new Object[]{"headerParams"});
        }
        if (this.getPagingParameterDefinedInPagination().isPresent() && this.externalizePagingParam()) {
            builder.addStatement("$L = " + this.getPagingParameterDefinedInPagination().get().getJavaName(), new Object[]{DEFAULT_PAGING_PARAMETER});
        }
        builder.addStatement("$L $L($L)", new Object[]{"return", this.getBaseMainMethodName(), params.stream().collect(Collectors.joining(", "))});
        return builder.build();
    }

    private Optional<SdkParameter> getPagingParameterDefinedInPagination() {
        return this.allQueryParameters.stream().filter(x -> this.isQueryParamDefinedInPagination(x.getExternalName())).findFirst();
    }

    @Override
    protected List<String> generateOperationMainCallParameters() {
        return AbstractSdkOperation.builder().configurationParameter().uriParametersMap().queryParametersMap().headerParametersMap().parameterBinding().customParameterBinding().requestBindingMethod().contentParameter(this.generateContentParameters(false)).requestParameter().configurationOverridesParameter().expressionLanguageMethod().parametersSpecStringList();
    }

    private List<String> generateExternalPagingProviderMethodMainCallParameters() {
        return AbstractSdkOperation.builder().configurationParameter().uriParametersMap().queryParametersMap().headerParametersMap().parameterBinding().emptyMapParameter().requestBindingParameter().nullParameter().configurationOverridesParameter().expressionLanguageParameter().parametersSpecStringList();
    }

    private AbstractSdkOperation.ParametersBuilder generateExternalPagingProviderMethodParameters() {
        return AbstractSdkOperation.builder().configurationParameter().parameterBinding().requestBindingParameter().configurationOverridesParameter().expressionLanguageParameter();
    }

    private CodeBlock generateExternalPagingProviderMethodBaseMainBody() throws TemplatingException {
        CodeBlock.Builder paginationBody = CodeBlock.builder();
        paginationBody.addStatement("$T<$T, $T> $L = $L($L.$L)", new Object[]{Map.class, String.class, Object.class, "queryParams", INITIALISE_QUERY_PARAMS, "requestBindings", "getQueryParams()"});
        paginationBody.addStatement("$T<$T, $T> $L = $L($L.$L)", new Object[]{Map.class, String.class, Object.class, "uriParams", INITIALISE_URI_PARAMS, "requestBindings", "getUriParams()"});
        paginationBody.addStatement("$T<$T, $T> $L = $L($L.$L)", new Object[]{Map.class, String.class, Object.class, "headerParams", INITIALISE_HEADER_PARAMS, "requestBindings", "getHeaders()"});
        List<String> params = this.generateExternalPagingProviderMethodMainCallParameters();
        paginationBody.addStatement("$L $L($L)", new Object[]{"return", this.getBaseMainMethodName(), params.stream().collect(Collectors.joining(", "))});
        return paginationBody.build();
    }

    @Override
    protected MethodSpec generateOperationBaseMethod() throws TemplatingException {
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)this.getJavaMethodName()).addModifiers(new Modifier[]{Modifier.PROTECTED});
        Pair<List<ParameterSpec>, CodeBlock.Builder> parameters = AbstractSdkOperation.builder().configurationParameter().uriParameters(this.allUriParameters).queryParameters(this.generateQueryParameters()).headerParameters(this.allHeaders).auxParameters(this.auxParameters).contentParameter(this.generateContentParameters(false)).requestParameter().configurationOverridesParameter().parametersSpecList();
        methodBuilder.addParameters((Iterable)parameters.getLeft());
        TypeName returnType = this.generateMethodReturn();
        methodBuilder.addStatement("$1T<$2T,$3T> $4L = new $5T<>()", new Object[]{Map.class, String.class, Object.class, "customParameterBindings", HashMap.class});
        methodBuilder.addCode(this.generateOperationMainCall(returnType));
        if (returnType != null) {
            methodBuilder.returns(returnType);
        }
        return methodBuilder.build();
    }

    private String getRequestBuilderMainName() {
        return this.getJavaMethodName() + BASE_REQUEST_BUILDER_MAIN_METHOD_NAME;
    }

    private String getPagingProviderMainName() {
        return this.getJavaMethodName() + BASE_PAGING_PROVIDER_MAIN_METHOD_NAME;
    }

    private void generateDefaultPagingParameterAttributeWithDefaultValue(List<FieldSpec> defaultValues) {
        Optional<SdkParameter> pagingParameter = this.getPagingParameterDefinedInPagination();
        if (pagingParameter.isPresent() && this.externalizePagingParam()) {
            FieldSpec.Builder fieldSpecBuilder = FieldSpec.builder(Integer.TYPE, (String)DEFAULT_PAGING_PARAMETER, (Modifier[])new Modifier[]{Modifier.PRIVATE});
            if (pagingParameter.get().getDefaultValue() != null && !pagingParameter.get().getDefaultValue().isEmpty()) {
                try {
                    fieldSpecBuilder.initializer("$L", new Object[]{Integer.parseInt(pagingParameter.get().getDefaultValue())});
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            defaultValues.add(fieldSpecBuilder.build());
        }
    }

    private void generateHttpParametersAttributesWithDefaultValue(List<Parameter> parameters, String defaultNamingConvention, List<FieldSpec> defaultValues) {
        for (Parameter param : parameters) {
            FieldSpec.Builder fieldSpecBuilder = FieldSpec.builder((Type)AbstractSdkPaginationOperation.getParameterPrimitiveJavaType(this.getTypeDefinition(param.getType())), (String)(JavaUtils.getParameterJavaName((String)param.getExternalName(), (boolean)(param.getTypeDefinition() instanceof ArrayTypeDefinition)) + defaultNamingConvention), (Modifier[])new Modifier[]{Modifier.PRIVATE});
            if (param.getDefaultValue() != null && !param.getDefaultValue().isEmpty()) {
                if (Number.class.isAssignableFrom(AbstractSdkPaginationOperation.getParameterPrimitiveJavaType(this.getTypeDefinition(param.getType())).getClass())) {
                    fieldSpecBuilder.initializer("$L", new Object[]{param.getDefaultValue()});
                } else {
                    fieldSpecBuilder.initializer("$S", new Object[]{param.getDefaultValue()});
                }
            }
            defaultValues.add(fieldSpecBuilder.build());
        }
    }

    private List<FieldSpec> generateAttributesDefaultValue() throws TemplatingException {
        ArrayList<FieldSpec> defaultValues = new ArrayList<FieldSpec>();
        this.generateDefaultPagingParameterAttributeWithDefaultValue(defaultValues);
        this.generateHttpParametersAttributesWithDefaultValue(this.operation.getQueryParameters().stream().filter(sdkParameter -> !this.isQueryParamDefinedInPagination(sdkParameter.getExternalName())).collect(Collectors.toList()), DEFAULT_QUERY_PARAM_NAME_CONVENTION, defaultValues);
        this.generateHttpParametersAttributesWithDefaultValue(this.operation.getUriParameters(), DEFAULT_URI_PARAM_NAME_CONVENTION, defaultValues);
        this.generateHttpParametersAttributesWithDefaultValue(this.operation.getHeaders(), DEFAULT_HEADER_PARAM_NAME_CONVENTION, defaultValues);
        return defaultValues;
    }

    private static Type getParameterPrimitiveJavaType(TypeDefinition typeDefinition) {
        if (typeDefinition instanceof ArrayTypeDefinition) {
            throw new IllegalArgumentException("Type is not primitive. Should handle arrays in templating. This is a bug.");
        }
        return TypeDefinitionUtil.getJavaType(typeDefinition);
    }

    private MethodSpec generateHttpDefaultMap(String methodName, String map, String nameConvention, List<SdkParameter> parameters, String parameterBinding) throws TemplatingException {
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)methodName).addModifiers(new Modifier[]{Modifier.PRIVATE}).returns(Map.class);
        methodBuilder.addParameters(Collections.singleton(ParameterSpec.builder((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(List.class), (TypeName[])new TypeName[]{TypeName.get(ParameterBinding.class)}), (String)parameterBinding, (Modifier[])new Modifier[0]).build()));
        methodBuilder.addStatement("$T<$T, $T> $L = new $T<>()", new Object[]{Map.class, String.class, Object.class, map, HashMap.class});
        for (SdkParameter param : parameters) {
            methodBuilder.addStatement("$L.put(\"" + param.getExternalName() + "\"," + JavaUtils.getParameterJavaName((String)param.getExternalName(), (boolean)param.isArrayType()) + "$L)", new Object[]{map, nameConvention});
        }
        methodBuilder.addStatement("return $L($L,$L)", new Object[]{FILTER_PARAMETERS_BOUND_METHOD, map, parameterBinding});
        return methodBuilder.build();
    }

    @Override
    protected void generateInstanceMethods(TypeSpec.Builder builder) throws TemplatingException {
        builder.addFields(this.generateAttributesDefaultValue());
        builder.addMethod(this.generateHttpDefaultMap(INITIALISE_QUERY_PARAMS, "queryParams", DEFAULT_QUERY_PARAM_NAME_CONVENTION, this.allQueryParameters.stream().filter(sdkParameter -> !this.isQueryParamDefinedInPagination(sdkParameter.getExternalName())).collect(Collectors.toList()), QUERY_PARAMS_REQUEST_BINDING));
        builder.addMethod(this.generateHttpDefaultMap(INITIALISE_URI_PARAMS, "uriParams", DEFAULT_URI_PARAM_NAME_CONVENTION, this.allUriParameters, URI_PARAMS_REQUEST_BINDING));
        builder.addMethod(this.generateHttpDefaultMap(INITIALISE_HEADER_PARAMS, "headerParams", DEFAULT_HEADER_PARAM_NAME_CONVENTION, this.allHeaders, HEADER_PARAMS_REQUEST_BINDING));
    }

    private List<ParameterSpec> getHttpParamsParameterSpecs() {
        ArrayList<ParameterSpec> httpParams = new ArrayList<ParameterSpec>();
        httpParams.add(ParameterSpec.builder(Map.class, (String)"uriParams", (Modifier[])new Modifier[0]).build());
        httpParams.add(ParameterSpec.builder(Map.class, (String)"queryParams", (Modifier[])new Modifier[0]).build());
        httpParams.add(ParameterSpec.builder(Map.class, (String)"headerParams", (Modifier[])new Modifier[0]).build());
        return httpParams;
    }

    private CodeBlock generateRequestBuilderMainCall() {
        CodeBlock.Builder requestBuilderCall = CodeBlock.builder();
        AbstractSdkOperation.ParametersBuilder parameters = AbstractSdkOperation.builder();
        parameters.requestParameter();
        parameters.configurationOverridesParameter();
        parameters.connectionParameter();
        parameters.configurationParameter();
        parameters.parameterBinding();
        parameters.customParameterBinding();
        parameters.requestBindingParameter();
        List parametersParsed = ((List)parameters.parametersSpecList().getLeft()).stream().map(x -> x.name).map(name -> {
            if (name.equals("parameterBindings")) {
                return "parameterBindingsRef.get()";
            }
            if (name.equals("customParameterBindings")) {
                return "customParameterBindingsRef.get()";
            }
            return name;
        }).collect(Collectors.toList());
        parametersParsed.addAll(this.getHttpParamsParameterSpecs().stream().map(param -> param.name).collect(Collectors.toList()));
        parametersParsed.addAll(AbstractSdkOperation.builder().expressionLanguageParameter().parametersSpecStringList());
        String parametersSpec = "$1L(" + parametersParsed.stream().collect(Collectors.joining(", ")) + ")";
        requestBuilderCall.add(parametersSpec, new Object[]{this.getRequestBuilderMainName()});
        return requestBuilderCall.build();
    }

    private CodeBlock generatePagingProviderCall() throws TemplatingException {
        CodeBlock.Builder requestBuilderCall = CodeBlock.builder();
        ArrayList parameters = new ArrayList(){
            {
                this.add(AbstractSdkPaginationOperation.PARAMETER_REQUEST_FACTORY);
                this.add("config");
                this.add("overrides");
                this.add("parameterBindings");
                this.add("customParameterBindings");
                this.add("expressionLanguage");
            }
        };
        String parametersSpec = "return $L(" + parameters.stream().collect(Collectors.joining(", ")) + ")";
        requestBuilderCall.addStatement(parametersSpec, new Object[]{this.getPagingProviderMainName()});
        return requestBuilderCall.build();
    }

    private void generateRequestBuilderMainMethodSignature(MethodSpec.Builder methodSpec) {
        AbstractSdkOperation.ParametersBuilder parameters = AbstractSdkOperation.builder();
        parameters.requestParameter();
        parameters.configurationOverridesParameter();
        parameters.connectionParameter();
        parameters.configurationParameter();
        parameters.parameterBinding();
        parameters.customParameterBinding();
        parameters.requestBindingParameter();
        parameters.uriParametersMap();
        parameters.queryParametersMap();
        parameters.headerParametersMap();
        parameters.expressionLanguageParameter();
        methodSpec.addParameters((Iterable)parameters.parametersSpecList().getLeft());
    }

    public MethodSpec generateRequestBuilderMainMethod() {
        MethodSpec.Builder methodSpecBuilder = MethodSpec.methodBuilder((String)this.getRequestBuilderMainName()).addModifiers(new Modifier[]{Modifier.PROTECTED});
        methodSpecBuilder.returns(RestRequestBuilder.class);
        this.generateRequestBuilderMainMethodSignature(methodSpecBuilder);
        methodSpecBuilder.addCode(this.generateRestRequestBuilder());
        methodSpecBuilder.addStatement("return builder", new Object[0]);
        return methodSpecBuilder.build();
    }

    @Override
    public CodeBlock generateRestRequestBuilder() {
        CodeBlock.Builder builder = CodeBlock.builder();
        builder.add(this.generateRestRequestBuilderInitialization(this.getBaseUriString()));
        builder.add(".setQueryParamFormat($L)", new Object[]{"QUERY_PARAM_FORMAT"});
        if (this.connectorModel.getInterceptors() != null && this.connectorModel.getInterceptors().size() > 0) {
            builder.add(".$L($L($L))", new Object[]{"responseInterceptorDescriptor", "getResponseInterceptorDescriptor", "config"});
        }
        if (this.operation.getInputMetadata() != null && this.operation.getInputMetadata().getMediaType() != null) {
            this.addContentTypeHeader(builder);
        }
        if (this.operation.getOutputMetadata() != null && this.operation.getOutputMetadata().getMediaType() != null) {
            builder.add(".$L($S, $S)", new Object[]{"addHeader", "accept", this.operation.getOutputMetadata().getMediaType().toString()});
        }
        if (!this.allUriParameters.isEmpty()) {
            builder.add(".$L($L)", new Object[]{ADD_URI_PARAMS_METHOD_NAME, "uriParams"});
        }
        if (this.allQueryParameters.stream().anyMatch(sdkParameter -> !this.isQueryParamDefinedInPagination(sdkParameter.getExternalName()))) {
            builder.add(".$L($L)", new Object[]{ADD_QUERY_PARAMS_METHOD_NAME, "queryParams"});
        }
        if (!this.allHeaders.isEmpty()) {
            builder.add(".$L($L)", new Object[]{ADD_HEADER_PARAMS_METHOD_NAME, "headerParams"});
        }
        this.addSetBodyMethod(builder);
        builder.add(";", new Object[0]);
        return builder.build();
    }

    @Override
    protected CodeBlock generateRestRequestBuilderInitialization(String baseUriString) {
        CodeBlock.Builder builder = CodeBlock.builder();
        AbstractSdkOperation.ParametersBuilder parameters = AbstractSdkOperation.builder();
        parameters.requestParameter();
        parameters.configurationOverridesParameter();
        parameters.connectionParameter();
        parameters.configurationParameter();
        parameters.parameterBinding();
        parameters.customParameterBinding();
        parameters.requestBindingParameter();
        parameters.expressionLanguageParameter();
        builder.add("$T builder = $L($L, $L, $T.$L, " + ((List)parameters.parametersSpecList().getLeft()).stream().map(x -> x.name).collect(Collectors.joining(", ")) + ")", new Object[]{RestRequestBuilder.class, "getRequestBuilderWithBindings", baseUriString, "OPERATION_PATH", HttpConstants.Method.class, this.operation.getHttpMethod().name().toUpperCase()});
        return builder.build();
    }

    private void generatePagingProviderMainMethodSignature(MethodSpec.Builder methodSpec) throws TemplatingException {
        ParameterSpec.Builder parameterBindingsSpec = ParameterSpec.builder((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(Function.class), (TypeName[])new TypeName[]{TypeName.get(RestConnection.class), TypeName.get(RestRequestBuilder.class)}), (String)PARAMETER_REQUEST_FACTORY, (Modifier[])new Modifier[0]);
        ArrayList<ParameterSpec> parameterSpecs = new ArrayList<ParameterSpec>();
        parameterSpecs.add(parameterBindingsSpec.build());
        AbstractSdkOperation.ParametersBuilder parameters = AbstractSdkOperation.builder().configurationParameter().configurationOverridesParameter().parameterBinding().customParameterBinding().expressionLanguageParameter();
        parameterSpecs.addAll((Collection)parameters.parametersSpecList().getLeft());
        methodSpec.addParameters(parameterSpecs);
    }

    public MethodSpec generatePagingProviderMainMethod() throws TemplatingException {
        MethodSpec.Builder methodSpecBuilder = MethodSpec.methodBuilder((String)this.getPagingProviderMainName()).addModifiers(new Modifier[]{Modifier.PROTECTED});
        this.generatePagingProviderMainMethodSignature(methodSpecBuilder);
        methodSpecBuilder.addCode(this.getPagingMethodOperation());
        TypeName returnType = this.generateMethodReturn();
        if (returnType != null) {
            methodSpecBuilder.returns(returnType);
        }
        return methodSpecBuilder.build();
    }

    protected List<SdkParameter> generateQueryParametersNoPaginated() {
        if (this.pagination.getPaginationParameter() != null) {
            return this.allQueryParameters.stream().filter(x -> !this.pagination.getPaginationParameter().equals(x.getExternalName())).collect(Collectors.toList());
        }
        return this.allQueryParameters.stream().collect(Collectors.toList());
    }

    @Override
    public String getPayloadExpression() {
        return this.pagination.getPaginationResponseExpression();
    }

    @Override
    protected boolean requiresMediaTypeAnnotation() {
        return false;
    }
}

