/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.templating.sdk.util;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.extension.api.annotation.metadata.MetadataKeyId;
import org.mule.runtime.extension.api.annotation.metadata.TypeResolver;
import org.mule.runtime.extension.api.annotation.param.Content;

public class MuleAnnotationsUtils {
    public static AnnotationSpec generateTypeResolverAnnotation(String fqn) {
        ClassName clsName = MuleAnnotationsUtils.getClassName(fqn);
        return MuleAnnotationsUtils.getTypeResolverAnnotation(clsName);
    }

    public static AnnotationSpec generateMetadataKeyIdAnnotation(String fqn) {
        AnnotationSpec.Builder builder = AnnotationSpec.builder(MetadataKeyId.class);
        if (StringUtils.isNotBlank((CharSequence)fqn)) {
            ClassName clsName = MuleAnnotationsUtils.getClassName(fqn);
            builder.addMember("value", "$T.class", new Object[]{clsName});
        }
        return builder.build();
    }

    public static AnnotationSpec getTypeResolverAnnotation(ClassName className) {
        return AnnotationSpec.builder(TypeResolver.class).addMember("value", "$T.class", new Object[]{className}).build();
    }

    public static ClassName getClassName(String fqn) {
        if (!fqn.contains(".")) {
            throw new IllegalArgumentException(String.format("The class [%s] is in the default package, it is a compile time error to import a type from the unnamed package for the class, please create a package for it", fqn));
        }
        int lasDot = fqn.lastIndexOf(".");
        String packageName = fqn.substring(0, lasDot);
        String className = fqn.substring(lasDot + 1);
        ClassName clsName = ClassName.get((String)packageName, (String)className, (String[])new String[0]);
        return clsName;
    }

    public static AnnotationSpec generateContentAnnotation() {
        return AnnotationSpec.builder(Content.class).build();
    }
}

