/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.templating.sdk.configuration.layers;

import static javax.lang.model.element.Modifier.ABSTRACT;
import static javax.lang.model.element.Modifier.PUBLIC;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorModel;
import com.mulesoft.connectivity.rest.sdk.templating.api.RestSdkRunConfiguration;
import com.mulesoft.connectivity.rest.sdk.templating.exception.TemplatingException;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.SdkConnector;

import java.nio.file.Path;

import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;

public class SdkConfigRefinementLayer extends AbstractSdkConfigLayer {

  public static final String REFINEMENT_LAYER_JAVADOC =
      "This refinement is the middle layer of the configuration generation gap pattern. "
          + "It can be overridden to add custom logic in the configuration.";

  private final TypeName baseClass;

  public SdkConfigRefinementLayer(Path outputDir, ConnectorModel connectorModel, SdkConnector sdkConnector, String javaClassName,
                                  String packageName, TypeName baseClass, RestSdkRunConfiguration runConfiguration) {
    super(outputDir, connectorModel, sdkConnector, javaClassName, packageName, runConfiguration);
    this.baseClass = baseClass;
  }

  @Override
  public void applyTemplates() throws TemplatingException {
    generateClass();
  }

  private void generateClass() throws TemplatingException {
    TypeSpec.Builder classBuilder =
        TypeSpec
            .classBuilder(getJavaClassName())
            .addModifiers(PUBLIC)
            .addModifiers(ABSTRACT)
            .superclass(baseClass)
            .addJavadoc(REFINEMENT_LAYER_JAVADOC);

    writeClassToFile(classBuilder.build(), getPackage(), true, connectorModel.getConfiguration().isRefined());
  }

  public String getJavaClassName() {
    return super.getJavaClassName() + REFINEMENT_CLASSNAME_SUFFIX;
  }

  public String getPackage() {
    return super.getPackage() + REFINEMENT_PACKAGE_SUFFIX;
  }

}
