/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.templating.sdk.connection.authentication;

import com.mulesoft.connectivity.rest.commons.api.connection.BasicAuthenticationConnectionProvider;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter.SecurityDefaultParameter;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.security.BasicAuthScheme;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.security.ConnectorSecurityScheme;

import com.squareup.javapoet.TypeSpec;

public class SdkBasicAuthenticationStrategy extends SdkUserPasswordAuthenticationStrategy {

  private final BasicAuthScheme basicAuthScheme;

  protected SdkBasicAuthenticationStrategy(
                                           ConnectorSecurityScheme securityScheme) {
    super(securityScheme);
    this.basicAuthScheme = (BasicAuthScheme) securityScheme;
  }

  @Override
  protected SecurityDefaultParameter getUsernameDefaultParameter() {
    if (basicAuthScheme.getBasicAuthDefaultParameters() == null) {
      return null;
    }
    return basicAuthScheme.getBasicAuthDefaultParameters().getUsername();
  }

  @Override
  protected SecurityDefaultParameter getPasswordDefaultParameter() {
    if (basicAuthScheme.getBasicAuthDefaultParameters() == null) {
      return null;
    }
    return basicAuthScheme.getBasicAuthDefaultParameters().getPassword();
  }

  @Override
  public Class<?> getCommonsBaseClass() {
    return BasicAuthenticationConnectionProvider.class;
  }

  @Override
  public void addClassAnnotations(TypeSpec.Builder connectionProviderClassBuilder) {

  }
}
