/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.templating.sdk.metadata;

import static com.mulesoft.connectivity.rest.sdk.templating.sdk.SdkConnector.API_METADATA_CATEGORY;
import static javax.lang.model.element.Modifier.PUBLIC;

import com.mulesoft.connectivity.rest.commons.api.datasense.metadata.output.HttpResponseAttributesMetadataResolver;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorModel;
import com.mulesoft.connectivity.rest.sdk.templating.JavaTemplateEntity;
import com.mulesoft.connectivity.rest.sdk.templating.api.RestSdkRunConfiguration;
import com.mulesoft.connectivity.rest.sdk.templating.exception.TemplatingException;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.SdkConnector;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;

import java.nio.file.Path;

public class SdkOutputAttributesMetadataResolver extends JavaTemplateEntity {

  private static final String GET_CATEGORY_NAME_METHOD_NAME = "getCategoryName";

  private String className;
  private String javaPackage;

  private SdkConnector sdkConnector;

  /***
   * Creates a type resolver that will generate a subclass of {@link HttpResponseAttributesMetadataResolver} for the output
   * attributes of operations/triggers.
   */
  public SdkOutputAttributesMetadataResolver(Path outputDir,
                                             ConnectorModel connectorModel,
                                             SdkConnector sdkConnector,
                                             RestSdkRunConfiguration runConfiguration) {
    super(outputDir, connectorModel, runConfiguration);

    this.className = buildClassName();
    this.javaPackage = buildJavaPackage();

    this.sdkConnector = sdkConnector;
  }

  private String buildClassName() {
    return HttpResponseAttributesMetadataResolver.class.getSimpleName();
  }

  private String buildJavaPackage() {
    return connectorModel.getBasePackage() + ".internal.metadata";
  }

  @Override
  public void applyTemplates() throws TemplatingException {
    TypeSpec.Builder typeResolverClassBuilder =
        TypeSpec
            .classBuilder(getClassName())
            .addModifiers(PUBLIC)
            .addJavadoc("Metadata output attributes resolver for {@link com.mulesoft.connectivity.rest.commons.api.operation.HttpResponseAttributes}.")
            .superclass(HttpResponseAttributesMetadataResolver.class);

    addGetCategoryNameMethod(typeResolverClassBuilder);

    writeClassToFile(typeResolverClassBuilder.build(), javaPackage);
  }

  private void addGetCategoryNameMethod(TypeSpec.Builder typeResolverClassBuilder) {
    CodeBlock methodBody = CodeBlock.builder()
        .addStatement("return $T." + API_METADATA_CATEGORY, sdkConnector.getTypeName())
        .build();

    MethodSpec getCategoryNameMethod = MethodSpec.methodBuilder(GET_CATEGORY_NAME_METHOD_NAME)
        .returns(TypeName.get(String.class))
        .addModifiers(PUBLIC)
        .addAnnotation(Override.class)
        .addCode(methodBody)
        .build();

    typeResolverClassBuilder.addMethod(getCategoryNameMethod);
  }

  public TypeName getTypeName() {
    return getClassName();
  }

  private ClassName getClassName() {
    return ClassName.get(javaPackage, className);
  }

}
