/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.templating.sdk.operation;

import static java.lang.String.format;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorModel;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.operation.ConnectorOperation;
import com.mulesoft.connectivity.rest.sdk.templating.api.RestSdkRunConfiguration;
import com.mulesoft.connectivity.rest.sdk.templating.exception.TemplatingException;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.SdkConnector;

import java.nio.file.Path;
import java.util.HashMap;

import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.TypeName;

public class SdkOperation extends AbstractSdkOperation {

  public SdkOperation(Path outputDir, ConnectorModel connectorModel, SdkConnector sdkConnector, ConnectorOperation operation,
                      RestSdkRunConfiguration runConfiguration)
      throws TemplatingException {
    super(outputDir, connectorModel, sdkConnector, operation, runConfiguration);
  }

  public TypeName generateMethodReturn() {
    return null;
  }

  public CodeBlock generateOperationMethodBaseMainBody() {
    return generateOperationMainMethodBody("callback");
  }

  protected CodeBlock generateOperationMainMethodBody(String callbackParameterName) {
    CodeBlock.Builder methodBody = CodeBlock.builder();
    methodBody.add(generateAuxParameterBindings());
    methodBody.add(toCursorProviderMapCodeBlock(PARAMETER_BINDINGS_NAME, CUSTOM_PARAMETER_BINDINGS_NAME));
    methodBody.add(generateRestRequestBuilder());

    generateDoRequestMethod(callbackParameterName, methodBody);
    return methodBody.build();
  }

  protected void generateDoRequestMethod(String callbackParameterName, CodeBlock.Builder methodBody) {
    generateDoRequestMethod(callbackParameterName, methodBody, PARAMETER_BINDINGS_NAME, CUSTOM_PARAMETER_BINDINGS_NAME);
  }

  protected void generateDoRequestMethod(String callbackParameterName, CodeBlock.Builder methodBody,
                                         String parametersBindingsVariableName,
                                         String customParametersBindingsVariableName) {
    if (hasOutput()) {
      String callbackAdapter = returnNullOnNotFoundError()
          ? "nullOnNotFoundErrorCompletionCallbackAdapter"
          : "callbackObjectAttributesAdapter";
      methodBody
          .addStatement(format("doRequest(config, connection, builder, overrides.getResponseTimeoutAsMillis(), %s, %s, %s(%s))",
                               parametersBindingsVariableName, customParametersBindingsVariableName, callbackAdapter,
                               callbackParameterName),
                        HashMap.class,
                        String.class, Object.class);
    } else {
      methodBody
          .addStatement(format("doVoidRequest(connection, builder, overrides.getResponseTimeoutAsMillis(), %s)",
                               callbackParameterName),
                        HashMap.class,
                        String.class, Object.class);
    }
  }

}
