/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.templating.sdk.connection;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorModel;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.security.ConnectorSecurityScheme;
import com.mulesoft.connectivity.rest.sdk.templating.api.RestSdkRunConfiguration;
import com.mulesoft.connectivity.rest.sdk.templating.exception.TemplatingException;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.SdkConnector;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.connection.AbstractSdkConnectionProvider;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.connection.authentication.SdkAuthenticationStrategy;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.connection.layers.SdkConnectionProviderBaseLayer;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.connection.layers.SdkConnectionProviderRefinementLayer;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.connection.layers.SdkConnectorProviderImplementationLayer;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.model.SdkHttpProxyConfig;
import com.squareup.javapoet.TypeName;
import java.nio.file.Path;

public class SdkConnectionProvider
extends AbstractSdkConnectionProvider {
    private final SdkConnectionProviderBaseLayer baseLayer;
    private final SdkConnectionProviderRefinementLayer refinementLayer;
    private final SdkConnectorProviderImplementationLayer implementationLayer;

    public SdkConnectionProvider(Path outputDir, ConnectorModel connectorModel, SdkConnector sdkConnector, ConnectorSecurityScheme securityScheme, SdkHttpProxyConfig httpProxyConfig, RestSdkRunConfiguration runConfiguration) throws TemplatingException {
        super(outputDir, connectorModel, runConfiguration);
        SdkAuthenticationStrategy authenticationStrategy = SdkAuthenticationStrategy.getStrategy(securityScheme);
        this.baseLayer = new SdkConnectionProviderBaseLayer(outputDir, sdkConnector, connectorModel, securityScheme, authenticationStrategy, httpProxyConfig, runConfiguration);
        this.refinementLayer = new SdkConnectionProviderRefinementLayer(outputDir, connectorModel, securityScheme, authenticationStrategy, this.baseLayer.getTypeName(), runConfiguration);
        this.implementationLayer = new SdkConnectorProviderImplementationLayer(outputDir, connectorModel, securityScheme, authenticationStrategy, this.refinementLayer.getTypeName(), runConfiguration);
    }

    @Override
    public void applyTemplates() throws TemplatingException {
        this.baseLayer.applyTemplates();
        this.refinementLayer.applyTemplates();
        this.implementationLayer.applyTemplates();
    }

    @Override
    public TypeName getTypeNameForConfig() {
        return this.implementationLayer.getTypeName();
    }
}

