/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.templating.sdk.trigger;

import com.mulesoft.connectivity.rest.commons.api.source.PaginatedBasedRestPollingSource;
import com.mulesoft.connectivity.rest.commons.api.source.RestPollingSource;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorModel;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.generic.ParameterDataType;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter.Parameter;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter.ParameterType;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter.TriggerParameter;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.trigger.Trigger;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.type.PrimitiveTypeDefinition;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.type.TypeDefinition;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.util.JavaUtils;
import com.mulesoft.connectivity.rest.sdk.templating.JavaTemplateEntity;
import com.mulesoft.connectivity.rest.sdk.templating.api.RestSdkRunConfiguration;
import com.mulesoft.connectivity.rest.sdk.templating.exception.TemplatingException;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.SdkConnector;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.parameter.SdkAuxiliarParameter;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.parameter.SdkParameter;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.trigger.SdkTriggerTemplate;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.trigger.layers.SdkTriggerBaseLayer;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.trigger.layers.SdkTriggerImplementationLayer;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.trigger.layers.SdkTriggerRefinementLayer;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.valueprovider.SdkValueProvidable;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.TypeName;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.ObjectUtils;

public class SdkTrigger
extends JavaTemplateEntity
implements SdkTriggerTemplate,
SdkValueProvidable {
    public static final String TRIGGER_CLASSNAME_SUFFIX = "Trigger";
    private static final String PACKAGE_SUFFIX = ".internal.source";
    private final SdkTriggerBaseLayer baseLayer;
    private final SdkTriggerRefinementLayer refinementLayer;
    private final SdkTriggerImplementationLayer implementationLayer;
    private final SdkConnector sdkConnector;
    private final Trigger trigger;
    private final List<SdkParameter> sdkParameters;
    private final String javaClassName;
    private final String packageName;

    public SdkTrigger(Path outputDir, ConnectorModel connectorModel, SdkConnector sdkConnector, Trigger trigger, RestSdkRunConfiguration runConfiguration) throws TemplatingException {
        super(outputDir, connectorModel, runConfiguration);
        this.sdkConnector = sdkConnector;
        this.trigger = trigger;
        this.sdkParameters = this.buildSdkParameters();
        this.javaClassName = this.getJavaClassName();
        this.packageName = this.getPackage();
        ClassName superclass = ClassName.get(RestPollingSource.class);
        if (trigger.getOperation().hasPagination()) {
            superclass = ClassName.get(PaginatedBasedRestPollingSource.class);
        }
        this.baseLayer = new SdkTriggerBaseLayer(outputDir, connectorModel, sdkConnector, trigger, this.sdkParameters, this.javaClassName, this.packageName, (TypeName)superclass, runConfiguration);
        this.refinementLayer = new SdkTriggerRefinementLayer(outputDir, connectorModel, sdkConnector, trigger, this.javaClassName, this.packageName, this.baseLayer.getTypeName(), runConfiguration);
        this.implementationLayer = new SdkTriggerImplementationLayer(outputDir, connectorModel, sdkConnector, trigger, this.javaClassName, this.packageName, this.refinementLayer.getTypeName(), this.sdkParameters, runConfiguration);
    }

    @Override
    public String getJavaClassName() {
        return JavaUtils.getJavaUpperCamelNameFromXml((String)this.trigger.getInternalName()) + TRIGGER_CLASSNAME_SUFFIX;
    }

    @Override
    public List<SdkParameter> getAllParameters() {
        return this.sdkParameters;
    }

    public String getPackage() {
        return this.connectorModel.getBasePackage() + PACKAGE_SUFFIX;
    }

    private List<SdkParameter> buildSdkParameters() throws TemplatingException {
        ArrayList<SdkParameter> list = new ArrayList<SdkParameter>();
        for (TriggerParameter parameter : this.trigger.getParameters()) {
            list.add(this.buildSdkParameter(parameter));
        }
        return list;
    }

    private SdkAuxiliarParameter buildSdkParameter(TriggerParameter triggerParameter) throws TemplatingException {
        TypeDefinition typeDefinition = triggerParameter.getTypeDefinition();
        if (typeDefinition == null && triggerParameter.getMuleTypeResolver() == null) {
            typeDefinition = this.getTypeDefinition(triggerParameter.getType());
        }
        Parameter parameter = new Parameter(triggerParameter.getDisplayName(), triggerParameter.getExternalName(), triggerParameter.getExternalName(), ParameterType.TRIGGER, typeDefinition, triggerParameter.getMuleAlias(), triggerParameter.getDescription(), triggerParameter.isRequired() == null || triggerParameter.isRequired() != false, null, false, triggerParameter.getValueProvider(), triggerParameter.getMuleMetadataKeyId(), triggerParameter.getMuleTypeResolver(), triggerParameter.getMuleContent(), Collections.emptyList(), triggerParameter.getSummary(), null);
        return new SdkAuxiliarParameter(this.outputDir, this.connectorModel, this.sdkConnector, this.trigger.getInternalName(), this.javaClassName, parameter, this, this.runConfiguration, (Boolean)ObjectUtils.defaultIfNull((Object)triggerParameter.getMuleContent(), (Object)false));
    }

    private TypeDefinition getTypeDefinition(ParameterDataType parameterDataType) {
        PrimitiveTypeDefinition.PrimitiveType primitiveType;
        switch (parameterDataType) {
            case NUMBER: {
                primitiveType = PrimitiveTypeDefinition.PrimitiveType.NUMBER;
                break;
            }
            case INTEGER: {
                primitiveType = PrimitiveTypeDefinition.PrimitiveType.INTEGER;
                break;
            }
            case LONG: {
                primitiveType = PrimitiveTypeDefinition.PrimitiveType.LONG;
                break;
            }
            case STRING: {
                primitiveType = PrimitiveTypeDefinition.PrimitiveType.STRING;
                break;
            }
            case BOOLEAN: {
                primitiveType = PrimitiveTypeDefinition.PrimitiveType.BOOLEAN;
                break;
            }
            case LOCAL_DATE_TIME: {
                primitiveType = PrimitiveTypeDefinition.PrimitiveType.LOCAL_DATE_TIME;
                break;
            }
            case ZONED_DATE_TIME: {
                primitiveType = PrimitiveTypeDefinition.PrimitiveType.ZONED_DATE_TIME;
                break;
            }
            default: {
                throw new IllegalArgumentException("Parameter type not supported. This is a bug.");
            }
        }
        return TypeDefinition.simplePrimitiveType((PrimitiveTypeDefinition.PrimitiveType)primitiveType);
    }

    @Override
    public void applyTemplates() throws TemplatingException {
        this.baseLayer.applyTemplates();
        this.refinementLayer.applyTemplates();
        this.implementationLayer.applyTemplates();
        for (SdkParameter sdkParameter : this.sdkParameters) {
            sdkParameter.applyTemplates();
        }
    }

    @Override
    public TypeName getTypeNameForConfig() {
        return this.implementationLayer.getTypeName();
    }
}

