/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.templating.sdk.valueprovider;

import com.mulesoft.connectivity.rest.commons.internal.model.builder.valueprovider.ValueProviderResolverDeclarationBuilder;
import com.mulesoft.connectivity.rest.commons.internal.model.builder.valueprovider.ValueProviderResolverExpressionBuilder;
import com.mulesoft.connectivity.rest.commons.internal.model.valueprovider.ValueProviderResolverDefinition;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.dataexpression.httprequest.HttpRequestBinding;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.generic.Argument;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter.ParameterType;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.resolver.ResolverExpression;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.resolver.ResolverReference;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.valueprovider.ValueProviderDefinition;
import com.mulesoft.connectivity.rest.sdk.templating.JavaTemplateEntity;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.resolver.SdkResolverDefinition;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.resolver.SdkResolverUtil;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import javax.lang.model.element.Modifier;
import org.apache.commons.lang3.StringUtils;

public class SdkValueProviderDefinition
implements SdkResolverDefinition<ValueProviderDefinition> {
    public static final String ITEMS_EXPRESSION_FIELD = "ITEMS_EXPRESSION";
    public static final String ITEM_VALUE_EXPRESSION_FIELD = "ITEM_VALUE_EXPRESSION";
    public static final String ITEM_NAME_EXPRESSION_FIELD = "ITEM_NAME_EXPRESSION";
    public static final String PATH_TEMPLATE_FIELD = "PATH";
    public static final String SCRIPT_TEMPLATE_FIELD = "SCRIPT";
    private final ValueProviderDefinition definition;
    private final boolean isTrigger;

    public SdkValueProviderDefinition(ResolverExpression<ValueProviderDefinition> valueProviderExpression, boolean isTrigger) {
        this.definition = this.getValueProviderDefinition(valueProviderExpression);
        this.isTrigger = isTrigger;
    }

    private ValueProviderDefinition getValueProviderDefinition(ResolverExpression<ValueProviderDefinition> valueProviderExpression) {
        if (valueProviderExpression instanceof ValueProviderDefinition) {
            return (ValueProviderDefinition)valueProviderExpression;
        }
        if (valueProviderExpression instanceof ResolverReference) {
            ResolverReference valueProviderReference = (ResolverReference)valueProviderExpression;
            return (ValueProviderDefinition)valueProviderReference.getDeclaration().getResolverDefinition();
        }
        throw new IllegalArgumentException("Invalid valueProviderExpression. This is a bug.");
    }

    @Override
    public CodeBlock.Builder getResolverExpressionBuilder() {
        CodeBlock.Builder codeBlockBuilder = CodeBlock.builder();
        if (this.definition.getRequest() != null) {
            HttpRequestBinding bindings;
            codeBlockBuilder.add("builder.definition(definitionBuilder -> definitionBuilder.httpRequest(httpRequestBuilder -> httpRequestBuilder.path($1L).method($2S)", new Object[]{PATH_TEMPLATE_FIELD, this.definition.getRequest().getMethod()});
            if (StringUtils.isNotBlank((CharSequence)this.definition.getRequest().getOutputMediaType())) {
                codeBlockBuilder.add(".outputMediaType($1S)", new Object[]{this.definition.getRequest().getOutputMediaType()});
            }
            if ((bindings = this.definition.getRequest().getHttpRequestBinding()) != null) {
                codeBlockBuilder.add(".bindings(bindingBuilder -> bindingBuilder", new Object[0]);
                bindings.getHeader().forEach(binding -> codeBlockBuilder.add(SdkValueProviderDefinition.getBindingCode(binding, ParameterType.HEADER)));
                bindings.getQueryParameter().forEach(binding -> codeBlockBuilder.add(SdkValueProviderDefinition.getBindingCode(binding, ParameterType.QUERY)));
                bindings.getUriParameter().forEach(binding -> codeBlockBuilder.add(SdkValueProviderDefinition.getBindingCode(binding, ParameterType.URI)));
                codeBlockBuilder.add(")", new Object[0]);
            }
        } else {
            codeBlockBuilder.add("builder.definition(definitionBuilder -> definitionBuilder.script(script -> script.scriptExpression(dw -> dw.expression($1L))", new Object[]{SCRIPT_TEMPLATE_FIELD});
        }
        codeBlockBuilder.add(")", new Object[0]);
        codeBlockBuilder.add(".itemExtractionExpression($1L).itemValueExpression($2L).itemNameExpression($3L))", new Object[]{ITEMS_EXPRESSION_FIELD, ITEM_VALUE_EXPRESSION_FIELD, ITEM_NAME_EXPRESSION_FIELD});
        return codeBlockBuilder;
    }

    private static CodeBlock getBindingCode(Argument binding, ParameterType parameterType) {
        CodeBlock.Builder bindingCodeBuilder = CodeBlock.builder();
        bindingCodeBuilder.add(".$1L($2S, argumentBuilder -> argumentBuilder.value(expressionBuilder -> expressionBuilder.expression($3S)))", new Object[]{SdkResolverUtil.getBindingMethod(parameterType), binding.getName(), binding.getValue().getValue()});
        return bindingCodeBuilder.build();
    }

    @Override
    public void addClassConstants(TypeSpec.Builder valueProviderClassBuilder) {
        valueProviderClassBuilder.addField(JavaTemplateEntity.getConstantStringField(ITEMS_EXPRESSION_FIELD, this.definition.getItemExtractionExpression())).addField(JavaTemplateEntity.getConstantStringField(ITEM_VALUE_EXPRESSION_FIELD, this.definition.getItemValueExpression())).addField(JavaTemplateEntity.getConstantStringField(ITEM_NAME_EXPRESSION_FIELD, this.definition.getItemDisplayNameExpression()));
        if (this.definition.getRequest() != null) {
            valueProviderClassBuilder.addField(JavaTemplateEntity.getConstantStringField(PATH_TEMPLATE_FIELD, this.definition.getRequest().getPath()));
        } else {
            valueProviderClassBuilder.addField(JavaTemplateEntity.getConstantStringField(SCRIPT_TEMPLATE_FIELD, this.definition.getScript()));
        }
    }

    @Override
    public void addBuildMethod(TypeSpec.Builder classBuilder, CodeBlock methodBody) {
        MethodSpec.Builder buildMethodBuilder = MethodSpec.methodBuilder((String)"build").addModifiers(new Modifier[]{Modifier.PROTECTED}).addParameter(TypeName.get(ValueProviderResolverExpressionBuilder.class), "builder", new Modifier[0]).addAnnotation(Override.class);
        buildMethodBuilder.addStatement(methodBody);
        classBuilder.addMethod(buildMethodBuilder.build());
    }

    @Override
    public ValueProviderDefinition getDefinition() {
        return this.definition;
    }

    @Override
    public Class<?> getSdkResolverDefinitionClass() {
        return ValueProviderResolverDefinition.class;
    }

    @Override
    public Class<?> getSdkResolverDeclarationBuilderClass() {
        return ValueProviderResolverDeclarationBuilder.class;
    }

    @Override
    public String getEvaluationContextKind() {
        return this.isTrigger ? "trigger" : "operation";
    }
}

