/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.templating.sdk.configuration;

import com.mulesoft.connectivity.rest.commons.api.configuration.RestConfiguration;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorModel;
import com.mulesoft.connectivity.rest.sdk.templating.JavaTemplateEntity;
import com.mulesoft.connectivity.rest.sdk.templating.api.RestSdkRunConfiguration;
import com.mulesoft.connectivity.rest.sdk.templating.exception.TemplatingException;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.SdkConnector;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.configuration.layers.SdkConfigBaseLayer;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.configuration.layers.SdkConfigImplementationLayer;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.configuration.layers.SdkConfigRefinementLayer;

import java.nio.file.Path;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.TypeName;

public class SdkConfig extends JavaTemplateEntity {

  public static final String CONFIGURATION_CLASSNAME_SUFFIX = "Configuration";
  private final SdkConnector connector;
  private final String javaClassName;
  private final String packageName;
  private final SdkConfigBaseLayer baseLayer;
  private final SdkConfigRefinementLayer interceptorLayer;
  private final SdkConfigImplementationLayer implementationLayer;

  public SdkConfig(Path outputDir,
                   ConnectorModel connectorModel,
                   SdkConnector sdkConnector,
                   RestSdkRunConfiguration runConfiguration)
      throws TemplatingException {
    super(outputDir, connectorModel, runConfiguration);
    this.connector = sdkConnector;

    javaClassName = getJavaClassName();
    packageName = getPackage();

    baseLayer = new SdkConfigBaseLayer(outputDir, connectorModel, sdkConnector, javaClassName, packageName,
                                       ClassName.get(RestConfiguration.class), runConfiguration);
    interceptorLayer = new SdkConfigRefinementLayer(outputDir, connectorModel, sdkConnector, javaClassName, packageName,
                                                    baseLayer.getTypeName(), runConfiguration);
    implementationLayer = new SdkConfigImplementationLayer(outputDir, connectorModel, sdkConnector, javaClassName, packageName,
                                                           interceptorLayer.getTypeName(), runConfiguration);
  }

  public String getJavaClassName() {
    String baseName =
        connector.getJavaName().endsWith("Connector") ? connector.getJavaName().substring(0, connector.getJavaName().length() - 9)
            : connector.getJavaName();

    return baseName + CONFIGURATION_CLASSNAME_SUFFIX;
  }

  public String getPackage() {
    return connectorModel.getBasePackage() + ".internal.config";
  }

  @Override
  public void applyTemplates() throws TemplatingException {
    baseLayer.applyTemplates();
    interceptorLayer.applyTemplates();
    implementationLayer.applyTemplates();
  }

  public TypeName getTypeName() {
    return implementationLayer.getTypeName();
  }

}
