/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.templating.sdk.munit;

import static com.mulesoft.connectivity.rest.sdk.internal.connectormodel.util.JavaUtils.getJavaUpperCamelNameFromXml;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.operation.ConnectorOperation;
import com.mulesoft.connectivity.rest.sdk.templating.VelocityTemplateEntity;
import com.mulesoft.connectivity.rest.sdk.templating.exception.TemplatingException;

import java.nio.file.Path;

public class SdkMtfOperationTest extends VelocityTemplateEntity {

  private final static String OPERATION_TEST_VM = "templates/sdk/operationMtfTest.vm";
  private final String testName;
  private final String configName;

  public SdkMtfOperationTest(ConnectorOperation operation, Path outputDir) {
    super(outputDir);

    testName = getJavaUpperCamelNameFromXml(operation.getInternalName()) + "OperationTest";
    configName = testName + ".xml";
  }

  public String getTestName() {
    return testName;
  }

  public String getConfigName() {
    return configName;
  }

  @Override
  public void applyTemplates() throws TemplatingException {
    applyTemplate(OPERATION_TEST_VM, outputDir.resolve("src/test/munit/" + getConfigName()));
  }
}
