/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.templating.api;

import com.mulesoft.connectivity.rest.sdk.templating.api.RestSdkMessageCollector;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;

public class RestSdkRunConfiguration {
    private final boolean skipValidations;
    private final boolean useDynamicTypeResolvers;
    private final String generatedSourcesDir;
    private final String sourceDir;
    private final String generatedResourcesDir;
    private final String overrideDir;
    private final String refinementDir;
    private final String ignoredDir;
    private final boolean regenerateMode;
    private final RestSdkMessageCollector messageCollector;
    private final String generatedSchemasDir;
    private final List<Path> processedRefinements;
    private final List<String> processedFiles;
    private final String customizationOverlayDir;
    private final String customizationOverlayFilename;
    private final boolean generateCustomizationOverlay;

    private RestSdkRunConfiguration(boolean skipValidations, boolean useDynamicTypeResolvers, String generatedSourcesDir, String sourceDir, String generatedResourcesDir, String overrideDir, String refinementSourceDir, String ignoredDir, boolean regenerateMode, String generatedSchemasDir, String customizationOverlayDir, String customizationOverlayFilename, boolean generateCustomizationOverlay) {
        this.skipValidations = skipValidations;
        this.useDynamicTypeResolvers = useDynamicTypeResolvers;
        this.generatedSourcesDir = generatedSourcesDir;
        this.sourceDir = sourceDir;
        this.overrideDir = overrideDir;
        this.ignoredDir = ignoredDir;
        this.regenerateMode = regenerateMode;
        this.generatedResourcesDir = generatedResourcesDir;
        this.messageCollector = new RestSdkMessageCollector();
        this.generatedSchemasDir = generatedSchemasDir;
        this.refinementDir = refinementSourceDir;
        this.processedRefinements = new ArrayList<Path>();
        this.processedFiles = new ArrayList<String>();
        this.customizationOverlayDir = customizationOverlayDir;
        this.customizationOverlayFilename = customizationOverlayFilename;
        this.generateCustomizationOverlay = generateCustomizationOverlay;
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean regenerateMode() {
        return this.regenerateMode;
    }

    public boolean skipValidations() {
        return this.skipValidations;
    }

    public boolean useDynamicTypeResolvers() {
        return this.useDynamicTypeResolvers;
    }

    public String getGeneratedSourcesDir() {
        return this.generatedSourcesDir;
    }

    public String getGeneratedResourcesDir() {
        return this.generatedResourcesDir;
    }

    public String getSourceDir() {
        return this.sourceDir;
    }

    public String getIgnoredDir() {
        return this.ignoredDir;
    }

    public String getOverrideDir() {
        return this.overrideDir;
    }

    public String getRefinementDir() {
        return this.refinementDir;
    }

    public RestSdkMessageCollector messageCollector() {
        return this.messageCollector;
    }

    public String getGeneratedSchemasDir() {
        return this.generatedSchemasDir;
    }

    public List<Path> getProcessedRefinements() {
        return this.processedRefinements;
    }

    public List<String> getProcessedFiles() {
        return this.processedFiles;
    }

    public String getCustomizationOverlayDir() {
        return this.customizationOverlayDir;
    }

    public String getCustomizationOverlayFilename() {
        return this.customizationOverlayFilename;
    }

    public boolean isGenerateCustomizationOverlay() {
        return this.generateCustomizationOverlay;
    }

    public static class Builder {
        private boolean skipValidations = false;
        private boolean useDynamicTypeResolvers = false;
        private String generatedSourceDir = "src/main/java";
        private String sourcesDir = "src/main/java";
        private String generatedResourcesDir = "src/main/resources";
        private String overrideSourceDir = "src/main/override";
        private String refinementSourceDir = "src/main/refinement";
        private String ignoreDir = "target/ignored";
        private boolean regenerateMode = false;
        private String generatedSchemasDir = "rest_sdk_generated_schemas";
        private String customizationOverlayDir = "target";
        private String customizationOverlayFilename = "rest-sdk-customization-overlay.yaml";
        private boolean generateCustomizationOverlay = true;

        public RestSdkRunConfiguration build() {
            return new RestSdkRunConfiguration(this.skipValidations, this.useDynamicTypeResolvers, this.generatedSourceDir, this.sourcesDir, this.generatedResourcesDir, this.overrideSourceDir, this.refinementSourceDir, this.ignoreDir, this.regenerateMode, this.generatedSchemasDir, this.customizationOverlayDir, this.customizationOverlayFilename, this.generateCustomizationOverlay);
        }

        public Builder skipValidations(boolean skipValidations) {
            this.skipValidations = skipValidations;
            return this;
        }

        public Builder generatedResourcesDir(String generatedResourcesDir) {
            this.generatedResourcesDir = generatedResourcesDir;
            return this;
        }

        public Builder generatedSourceDir(String generatedSourceDir) {
            this.generatedSourceDir = generatedSourceDir;
            return this;
        }

        public Builder sourcesDir(String sourcesDir) {
            this.sourcesDir = sourcesDir;
            return this;
        }

        public Builder regenerateMode(boolean regenerateMode) {
            this.regenerateMode = regenerateMode;
            return this;
        }

        public Builder ignoredDir(String ignoredDir) {
            this.ignoreDir = ignoredDir;
            return this;
        }

        public Builder overrideSourceDir(String relativeOverridePath) {
            this.overrideSourceDir = relativeOverridePath;
            return this;
        }

        public Builder refinementSourceDir(String relativeRefinementPath) {
            this.refinementSourceDir = relativeRefinementPath;
            return this;
        }

        public Builder useDynamicTypeResolvers(boolean useDynamicTypeResolvers) {
            this.useDynamicTypeResolvers = useDynamicTypeResolvers;
            return this;
        }

        public Builder generatedSchemasDir(String generatedSchemasDir) {
            this.generatedSchemasDir = generatedSchemasDir;
            return this;
        }

        public Builder customizationOverlayDir(String customizationOverlayDir) {
            this.customizationOverlayDir = customizationOverlayDir;
            return this;
        }

        public Builder customizationOverlayFilename(String customizationOverlayFilename) {
            this.customizationOverlayFilename = customizationOverlayFilename;
            return this;
        }

        public Builder generateCustomizationOverlay(boolean generateCustomizationOverlay) {
            this.generateCustomizationOverlay = generateCustomizationOverlay;
            return this;
        }
    }
}

