/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.templating.sdk.metadata;

import com.mulesoft.connectivity.rest.commons.api.datasense.metadata.output.HttpResponseAttributesMetadataResolver;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorModel;
import com.mulesoft.connectivity.rest.sdk.templating.JavaTemplateEntity;
import com.mulesoft.connectivity.rest.sdk.templating.api.RestSdkRunConfiguration;
import com.mulesoft.connectivity.rest.sdk.templating.exception.TemplatingException;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.SdkConnector;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.nio.file.Path;
import javax.lang.model.element.Modifier;

public class SdkOutputAttributesMetadataResolver
extends JavaTemplateEntity {
    private static final String GET_CATEGORY_NAME_METHOD_NAME = "getCategoryName";
    private String className = this.buildClassName();
    private String javaPackage = this.buildJavaPackage();
    private SdkConnector sdkConnector;

    public SdkOutputAttributesMetadataResolver(Path outputDir, ConnectorModel connectorModel, SdkConnector sdkConnector, RestSdkRunConfiguration runConfiguration) {
        super(outputDir, connectorModel, runConfiguration);
        this.sdkConnector = sdkConnector;
    }

    private String buildClassName() {
        return HttpResponseAttributesMetadataResolver.class.getSimpleName();
    }

    private String buildJavaPackage() {
        return this.connectorModel.getBasePackage() + ".internal.metadata";
    }

    @Override
    public void applyTemplates() throws TemplatingException {
        TypeSpec.Builder typeResolverClassBuilder = TypeSpec.classBuilder((ClassName)this.getClassName()).addModifiers(new Modifier[]{Modifier.PUBLIC}).addJavadoc("Metadata output attributes resolver for {@link com.mulesoft.connectivity.rest.commons.api.operation.HttpResponseAttributes}.", new Object[0]).superclass(HttpResponseAttributesMetadataResolver.class);
        this.addGetCategoryNameMethod(typeResolverClassBuilder);
        this.writeClassToFile(typeResolverClassBuilder.build(), this.javaPackage);
    }

    private void addGetCategoryNameMethod(TypeSpec.Builder typeResolverClassBuilder) {
        CodeBlock methodBody = CodeBlock.builder().addStatement("return $T.API_METADATA_CATEGORY", new Object[]{this.sdkConnector.getTypeName()}).build();
        MethodSpec getCategoryNameMethod = MethodSpec.methodBuilder((String)GET_CATEGORY_NAME_METHOD_NAME).returns(TypeName.get(String.class)).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).addCode(methodBody).build();
        typeResolverClassBuilder.addMethod(getCategoryNameMethod);
    }

    public TypeName getTypeName() {
        return this.getClassName();
    }

    private ClassName getClassName() {
        return ClassName.get((String)this.javaPackage, (String)this.className, (String[])new String[0]);
    }
}

