/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.templating.sdk.sampledata;

import com.mulesoft.connectivity.rest.commons.api.datasense.sampledata.PagedRestSampleDataProvider;
import com.mulesoft.connectivity.rest.commons.api.datasense.sampledata.RestSampleDataProvider;
import com.mulesoft.connectivity.rest.commons.internal.model.builder.sampledata.SampleDataResolverDeclarationBuilder;
import com.mulesoft.connectivity.rest.commons.internal.model.builder.sampledata.SampleDataResolverExpressionBuilder;
import com.mulesoft.connectivity.rest.commons.internal.model.sampledata.SampleDataResolverDefinition;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.dataexpression.httprequest.HttpRequestBinding;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.generic.Argument;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter.ParameterType;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.resolver.ResolverExpression;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.resolver.ResolverReference;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.sampledata.SampleDataDefinition;
import com.mulesoft.connectivity.rest.sdk.templating.JavaTemplateEntity;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.resolver.SdkResolverDefinition;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.resolver.SdkResolverUtil;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import javax.lang.model.element.Modifier;
import org.apache.commons.lang3.StringUtils;

public class SdkSampleDataDefinition
implements SdkResolverDefinition<SampleDataDefinition> {
    public static final String PATH_TEMPLATE_FIELD = "PATH";
    public static final String SAMPLE_DATA_SUFFIX = "SampleDataProvider";
    public static final String SCRIPT_TEMPLATE_FIELD = "SCRIPT";
    private final SampleDataDefinition definition;
    private final boolean isTrigger;
    private final boolean isPaged;

    public SdkSampleDataDefinition(ResolverExpression<SampleDataDefinition> resolverExpression, boolean isTrigger, boolean isPaged) {
        this.definition = this.buildDefinition(resolverExpression);
        this.isTrigger = isTrigger;
        this.isPaged = isPaged;
    }

    private SampleDataDefinition buildDefinition(ResolverExpression<SampleDataDefinition> resolverExpression) {
        if (resolverExpression instanceof SampleDataDefinition) {
            return (SampleDataDefinition)resolverExpression;
        }
        if (resolverExpression instanceof ResolverReference) {
            ResolverReference valueProviderReference = (ResolverReference)resolverExpression;
            return (SampleDataDefinition)valueProviderReference.getDeclaration().getResolverDefinition();
        }
        throw new IllegalArgumentException("Invalid resolverExpression. This is a bug.");
    }

    @Override
    public CodeBlock.Builder getResolverExpressionBuilder() {
        CodeBlock.Builder codeBlockBuilder = CodeBlock.builder();
        if (this.definition.getResult() != null) {
            HttpRequestBinding bindings;
            codeBlockBuilder.add("builder.definition(definitionBuilder -> definitionBuilder.result(httpRequestBuilder -> httpRequestBuilder.path($1L).method($2S)", new Object[]{PATH_TEMPLATE_FIELD, this.definition.getResult().getMethod()});
            if (StringUtils.isNotBlank((CharSequence)this.definition.getResult().getOutputMediaType())) {
                codeBlockBuilder.add(".outputMediaType($1S)", new Object[]{this.definition.getResult().getOutputMediaType()});
            }
            if ((bindings = this.definition.getResult().getHttpRequestBinding()) != null) {
                codeBlockBuilder.add(".bindings(bindingBuilder -> bindingBuilder", new Object[0]);
                bindings.getHeader().forEach(binding -> codeBlockBuilder.add(SdkSampleDataDefinition.getBindingCode(binding, ParameterType.HEADER)));
                bindings.getQueryParameter().forEach(binding -> codeBlockBuilder.add(SdkSampleDataDefinition.getBindingCode(binding, ParameterType.QUERY)));
                bindings.getUriParameter().forEach(binding -> codeBlockBuilder.add(SdkSampleDataDefinition.getBindingCode(binding, ParameterType.URI)));
                codeBlockBuilder.add(")", new Object[0]);
            }
        } else {
            codeBlockBuilder.add("builder.definition(definitionBuilder -> definitionBuilder.script(script -> script.scriptExpression(dw -> dw.expression($1L))", new Object[]{SCRIPT_TEMPLATE_FIELD});
        }
        codeBlockBuilder.add(")", new Object[0]);
        if (this.needsTransformation()) {
            codeBlockBuilder.add(".transform(t -> t.scriptExpression(expressionBuilder -> expressionBuilder.expression($S)))", new Object[]{this.getTransformation()});
        }
        codeBlockBuilder.add(")", new Object[0]);
        return codeBlockBuilder;
    }

    private boolean needsTransformation() {
        return StringUtils.isNotBlank((CharSequence)this.getTransformation());
    }

    private String getTransformation() {
        return this.definition.getTransformation() == null ? null : this.definition.getTransformation().getExpression();
    }

    private static CodeBlock getBindingCode(Argument binding, ParameterType parameterType) {
        CodeBlock.Builder bindingCodeBuilder = CodeBlock.builder();
        bindingCodeBuilder.add(".$1L($2S, argumentBuilder -> argumentBuilder.value(expressionBuilder -> expressionBuilder.expression($3S)))", new Object[]{SdkResolverUtil.getBindingMethod(parameterType), binding.getName(), binding.getValue().getValue()});
        return bindingCodeBuilder.build();
    }

    @Override
    public void addClassConstants(TypeSpec.Builder resolverClassBuilder) {
        if (this.definition.getResult() != null) {
            resolverClassBuilder.addField(JavaTemplateEntity.getConstantStringField(PATH_TEMPLATE_FIELD, this.definition.getResult().getPath()));
        } else {
            resolverClassBuilder.addField(JavaTemplateEntity.getConstantStringField(SCRIPT_TEMPLATE_FIELD, this.definition.getScript()));
        }
    }

    @Override
    public void addBuildMethod(TypeSpec.Builder classBuilder, CodeBlock methodBody) {
        MethodSpec.Builder buildMethodBuilder = MethodSpec.methodBuilder((String)"build").addModifiers(new Modifier[]{Modifier.PROTECTED}).addParameter(TypeName.get(SampleDataResolverExpressionBuilder.class), "builder", new Modifier[0]).addAnnotation(Override.class);
        buildMethodBuilder.addStatement(methodBody);
        classBuilder.addMethod(buildMethodBuilder.build());
    }

    @Override
    public String getEvaluationContextKind() {
        return this.isTrigger ? "trigger" : "operation";
    }

    @Override
    public SampleDataDefinition getDefinition() {
        return this.definition;
    }

    @Override
    public Class<?> getSdkResolverDefinitionClass() {
        return SampleDataResolverDefinition.class;
    }

    @Override
    public Class<?> getSdkResolverDeclarationBuilderClass() {
        return SampleDataResolverDeclarationBuilder.class;
    }

    public Class<?> getSuperclass() {
        return this.isPaged ? PagedRestSampleDataProvider.class : RestSampleDataProvider.class;
    }
}

