/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.templating.sdk.util;

import static com.mulesoft.connectivity.rest.sdk.internal.connectormodel.util.JavaUtils.getJavaLowerCamelNameFromXml;
import static com.mulesoft.connectivity.rest.sdk.internal.webapi.util.XmlUtils.getXmlName;
import static org.apache.commons.lang3.StringUtils.isNotBlank;
import static org.mule.runtime.extension.api.util.NameUtils.pluralize;

import org.mule.metadata.api.model.ArrayType;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.json.api.JsonTypeLoader;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorOperation;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.metadata.SdkInputMetadataResolver;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.parameter.SdkContent;

import java.util.Optional;

public class ContentNameGenerator {

  private static final String CONTENT_DEFAULT_NAME = "body";

  public static String getContentName(ConnectorOperation operation,
                                      SdkInputMetadataResolver metadataResolver,
                                      SdkContent.SdkContentKind contentType,
                                      String partName) {

    StringBuilder xmlTypeName = new StringBuilder(operation.getInternalName());
    switch (contentType) {
      case INPUT_METADATA:
        // does nothing, there's just one @Content
        break;
      case PART:
        // multipart scenario, each @Content must be named after its part sanitizing the partName
        xmlTypeName
            .append("-")
            .append(getXmlName(partName));
        break;
    }

    xmlTypeName
        .append("-")
        .append(CONTENT_DEFAULT_NAME);

    String javaContentName = getJavaLowerCamelNameFromXml(xmlTypeName.toString());
    return pluralizeBySchema(javaContentName, metadataResolver);
  }

  /**
   * Given a javaContentName, if the schema is an array type, then it will pluralize the name
   * 
   * @param javaContentName generated name for the content
   * @param metadataResolver input resolver for the @Content element
   * @return the content name pluralized if needed, or the {@code javaContentName} untouched
   */
  private static String pluralizeBySchema(String javaContentName, SdkInputMetadataResolver metadataResolver) {
    String result = javaContentName;
    String schemaName = metadataResolver.getSchemaName();
    if (isNotBlank(schemaName) && schemaName.endsWith(".json")) {
      final JsonTypeLoader jsonTypeLoader =
          new JsonTypeLoader(metadataResolver.getTypeDefinition().getTypeSchema().getRawSchema());
      final Optional<MetadataType> metadataType = jsonTypeLoader.load(null);

      if (metadataType.isPresent()) {
        if (metadataType.get() instanceof ArrayType) {
          result = pluralize(javaContentName);
        }
      }
    }
    return result;
  }
}
