/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.templating.sdk.resolver;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.dataexpression.httprequest.HttpRequestBinding;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter.ParameterType;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.parameter.SdkParameter;
import java.util.List;

public class SdkResolverUtil {
    public static String getBindingMethod(ParameterType parameterType) {
        switch (parameterType) {
            case URI: {
                return "uriParameter";
            }
            case QUERY: {
                return "queryParameter";
            }
            case HEADER: {
                return "header";
            }
        }
        throw new IllegalArgumentException();
    }

    public static boolean isBoundParameterForHttpBinding(SdkParameter sdkParameter, HttpRequestBinding httpBinding) {
        List parameterBindings;
        if (httpBinding == null) {
            return false;
        }
        switch (sdkParameter.getParameterType()) {
            case URI: {
                parameterBindings = httpBinding.getUriParameter();
                break;
            }
            case QUERY: {
                parameterBindings = httpBinding.getQueryParameter();
                break;
            }
            case HEADER: {
                parameterBindings = httpBinding.getHeader();
                break;
            }
            default: {
                throw new IllegalArgumentException("Parameter type not supported. This is a bug.");
            }
        }
        return parameterBindings.stream().anyMatch(x -> x.getValue().getValue().contains(SdkResolverUtil.getBindingMethod(sdkParameter.getParameterType()) + "." + sdkParameter.getExternalName()));
    }
}

