/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.templating.sdk.sampledata;

import static com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter.ParameterType.TRIGGER;
import static com.mulesoft.connectivity.rest.sdk.templating.sdk.resolver.SdkResolverUtil.isBoundParameterForHttpBinding;
import static com.mulesoft.connectivity.rest.sdk.templating.sdk.sampledata.SdkSampleDataDefinition.SAMPLE_DATA_SUFFIX;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorModel;
import com.mulesoft.connectivity.rest.sdk.templating.api.RestSdkRunConfiguration;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.parameter.SdkParameter;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.resolver.AbstractSdkResolverProviderInline;

import java.nio.file.Path;
import java.util.List;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.TypeName;

public class SdkSampleDataInline extends AbstractSdkResolverProviderInline {

  private final SdkSampleDataDefinition sdkResolverDefinition;
  private final List<SdkParameter> sdkParameters;
  private final String parentClassName;

  public SdkSampleDataInline(Path outputDir,
                             ConnectorModel connectorModel,
                             String parentClassName,
                             List<SdkParameter> sdkParameters,
                             SdkSampleDataDefinition sdkResolverDefinition,
                             RestSdkRunConfiguration runConfiguration) {
    super(outputDir, connectorModel, sdkResolverDefinition, runConfiguration);
    this.sdkResolverDefinition = sdkResolverDefinition;
    this.sdkParameters = sdkParameters;
    this.parentClassName = parentClassName;
  }

  public String getPackage() {
    return connectorModel.getBasePackage() + ".internal.metadata.sample";
  }

  public String getJavaClassName() {
    return parentClassName + SAMPLE_DATA_SUFFIX;
  }

  @Override
  protected List<SdkParameter> getAllParameters() {
    return sdkParameters;
  }

  @Override
  protected String getEvaluationContextKind() {
    return sdkResolverDefinition.getEvaluationContextKind();
  }

  @Override
  protected TypeName getSuperClass() {
    return ClassName.get(sdkResolverDefinition.getSuperclass());
  }

  @Override
  protected boolean isBoundParameter(SdkParameter sdkParameter) {
    if (sdkParameter.getParameterType().equals(TRIGGER)) {
      return true;
    }

    return isBoundParameterForHttpBinding(sdkParameter,
                                          sdkResolverDefinition.getDefinition().getResult().getHttpRequestBinding());
  }
}
